/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.entity.account;

import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.enumeration.entity.ResourceType;
import com.github.dactiv.showcase.entity.IdEntity;
import com.github.dactiv.showcase.entity.account.Group;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;

@Entity
@Table(name="TB_RESOURCE")
@NamedQueries(value={@NamedQuery(name="userResources", query="select rl from User u left join u.groupsList gl left join gl.resourcesList rl where u.id=?1 and gl.type= '03' order by rl.sort"), @NamedQuery(name="leafTureNotAssociated", query="from Resource r where r.leaf = 1 and (select count(sr) from Resource sr where sr.parent.id = r.id) = 0")})
public class Resource
extends IdEntity {
    private static final long serialVersionUID = 1L;
    public static final String UserResources = "userResources";
    public static final String LeafTureNotAssociated = "leafTureNotAssociated";
    private String name;
    private String value;
    private Resource parent;
    private Long sort;
    private boolean leaf;
    private List<Resource> children = new ArrayList();
    private String remark;
    private String type;
    private List<Group> groupsList = new ArrayList();
    private String permission;
    private String icon;

    @Column(length=32, nullable=false, unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(length=256)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_PARENT_ID")
    public Resource getParent() {
        return this.parent;
    }

    public void setParent(Resource parent) {
        this.parent = parent;
    }

    @Column(nullable=false)
    public Long getSort() {
        return this.sort;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    public Boolean getLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    @OrderBy(value="sort ASC")
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<Resource> getChildren() {
        return this.children;
    }

    public void setChildren(List<Resource> children) {
        this.children = children;
    }

    @Column(length=512)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Column(nullable=false, length=2)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="TB_GROUP_RESOURCE", joinColumns={@JoinColumn(name="FK_RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="FK_GROUP_ID")})
    public List<Group> getGroupsList() {
        return this.groupsList;
    }

    public void setGroupsList(List<Group> groupsList) {
        this.groupsList = groupsList;
    }

    @Transient
    public String getParentName() {
        return this.parent == null ? "" : this.parent.getName();
    }

    @Transient
    public String getParentId() {
        return this.parent == null ? "" : this.parent.getId();
    }

    @Column(length=64)
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Column(length=32)
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Transient
    public String getTypeName() {
        return SystemVariableUtils.getName(ResourceType.class, (Object)this.type);
    }
}

