/*
 * Decompiled with CFR 0.152.
 */
package dmax.dialog;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.widget.TextView;
import dmax.dialog.AnimatedView;
import dmax.dialog.AnimatorPlayer;
import dmax.dialog.HesitateInterpolator;
import dmax.dialog.ProgressLayout;
import dmax.dialog.R;

public class SpotsDialog
extends AlertDialog {
    private static final int DELAY = 150;
    private static final int DURATION = 1500;
    private int size;
    private AnimatedView[] spots;
    private AnimatorPlayer animator;
    private CharSequence message;

    public SpotsDialog(Context context) {
        this(context, R.style.SpotsDialogDefault);
    }

    public SpotsDialog(Context context, CharSequence message) {
        this(context);
        this.message = message;
    }

    public SpotsDialog(Context context, int theme) {
        super(context, theme);
    }

    public SpotsDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog);
        this.setCanceledOnTouchOutside(false);
        this.initMessage();
        this.initProgress();
    }

    protected void onStart() {
        super.onStart();
        this.animator = new AnimatorPlayer(this.createAnimations());
        this.animator.play();
    }

    protected void onStop() {
        super.onStop();
        this.animator.stop();
    }

    private void initMessage() {
        if (this.message != null && this.message.length() > 0) {
            ((TextView)this.findViewById(R.id.title)).setText(this.message);
        }
    }

    private void initProgress() {
        ProgressLayout progress = (ProgressLayout)this.findViewById(R.id.progress);
        this.size = progress.getSpotsCount();
        this.spots = new AnimatedView[this.size];
        int size = this.getContext().getResources().getDimensionPixelSize(R.dimen.spot_size);
        int progressWidth = this.getContext().getResources().getDimensionPixelSize(R.dimen.progress_width);
        for (int i = 0; i < this.spots.length; ++i) {
            AnimatedView v = new AnimatedView(this.getContext());
            v.setBackgroundResource(R.drawable.spot);
            v.setTarget(progressWidth);
            v.setXFactor(-1.0f);
            progress.addView(v, size, size);
            this.spots[i] = v;
        }
    }

    private Animator[] createAnimations() {
        Animator[] animators = new Animator[this.size];
        for (int i = 0; i < this.spots.length; ++i) {
            ObjectAnimator move = ObjectAnimator.ofFloat((Object)((Object)this.spots[i]), (String)"xFactor", (float[])new float[]{0.0f, 1.0f});
            move.setDuration(1500L);
            move.setInterpolator((TimeInterpolator)new HesitateInterpolator());
            move.setStartDelay((long)(150 * i));
            animators[i] = move;
        }
        return animators;
    }
}

