/*
 * Decompiled with CFR 0.152.
 */
package dmax.dialog;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import dmax.dialog.AnimatedView;
import dmax.dialog.HesitateInterpolator;
import dmax.dialog.ProgressLayout;
import dmax.dialog.R;

public class SpotsDialog
extends AlertDialog {
    private static final int DELAY = 150;
    private static final int DURATION = 1500;
    private int size;
    private AnimatedView[] spots;
    private Animator[] animators;
    private AnimatorListenerAdapter listener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            SpotsDialog.this.animate();
        }
    };

    public SpotsDialog(Context context) {
        this(context, R.style.SpotsDialogDefault);
    }

    public SpotsDialog(Context context, int theme) {
        super(context, theme);
    }

    public SpotsDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog);
        this.setCanceledOnTouchOutside(false);
        this.initProgress();
    }

    protected void onStart() {
        super.onStart();
        this.animate();
    }

    private void animate() {
        if (this.animators == null) {
            this.animators = this.createAnimations();
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(this.animators);
        set.addListener((Animator.AnimatorListener)this.listener);
        set.start();
    }

    private void initProgress() {
        ProgressLayout progress = (ProgressLayout)this.findViewById(R.id.progress);
        this.size = progress.getSpotsCount();
        this.spots = new AnimatedView[this.size];
        int size = this.getContext().getResources().getDimensionPixelSize(R.dimen.spot_size);
        int progressWidth = this.getContext().getResources().getDimensionPixelSize(R.dimen.progress_width);
        for (int i = 0; i < this.spots.length; ++i) {
            AnimatedView v = new AnimatedView(this.getContext());
            v.setBackgroundResource(R.drawable.spot);
            v.setTarget(progressWidth);
            v.setXFactor(-1.0f);
            progress.addView(v, size, size);
            this.spots[i] = v;
        }
    }

    private Animator[] createAnimations() {
        Animator[] animators = new Animator[this.size];
        for (int i = 0; i < this.spots.length; ++i) {
            ObjectAnimator move = ObjectAnimator.ofFloat((Object)((Object)this.spots[i]), (String)"xFactor", (float[])new float[]{0.0f, 1.0f});
            move.setDuration(1500L);
            move.setInterpolator((TimeInterpolator)new HesitateInterpolator());
            move.setStartDelay((long)(150 * i));
            animators[i] = move;
        }
        return animators;
    }
}

