/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.parsing.dflt;

import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Group;
import com.github.curiousoddman.rgxgen.generator.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.parsing.NodeTreeBuilder;
import com.github.curiousoddman.rgxgen.parsing.dflt.CharIterator;
import com.github.curiousoddman.rgxgen.parsing.dflt.RgxGenParseException;
import com.github.curiousoddman.rgxgen.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class DefaultTreeBuilder
implements NodeTreeBuilder {
    private static final String[] SINGLETON_UNDERSCORE_ARRAY = new String[]{"_"};
    private static final int HEX_RADIX = 16;
    private static final String[] EMPTY_STRINGS_ARR = new String[0];
    private static final Node[] EMPTY_NODES_ARR = new Node[0];
    private final CharIterator aCharIterator;
    private final Map<Node, Integer> aNodesStartPos = new IdentityHashMap<Node, Integer>();
    private static final ConstantsProvider CONST_PROVIDER = new ConstantsProvider();
    private Node aNode;
    private int aNextGroupIndex = 1;

    public DefaultTreeBuilder(String expr) {
        this.aCharIterator = new CharIterator(expr);
    }

    private void sbToFinal(StringBuilder sb, List<Node> nodes) {
        if (sb.length() != 0) {
            FinalSymbol finalSymbol = new FinalSymbol(sb.toString());
            this.aNodesStartPos.put(finalSymbol, this.aCharIterator.pos() - finalSymbol.getValue().length());
            nodes.add(finalSymbol);
            sb.delete(0, Integer.MAX_VALUE);
        }
    }

    private GroupType processGroupType() {
        switch (this.aCharIterator.next(2)) {
            case "?=": {
                return GroupType.POSITIVE_LOOKAHEAD;
            }
            case "?:": {
                return GroupType.NON_CAPTURE_GROUP;
            }
            case "?!": {
                return GroupType.NEGATIVE_LOOKAHEAD;
            }
            case "?<": {
                GroupType res = GroupType.POSITIVE_LOOKBEHIND;
                char next = this.aCharIterator.next().charValue();
                if (next == '!') {
                    res = GroupType.NEGATIVE_LOOKBEHIND;
                } else if (next != '=') {
                    throw new RgxGenParseException("Unexpected symbol in pattern: " + this.aCharIterator.context());
                }
                return res;
            }
        }
        this.aCharIterator.skip(-2);
        return GroupType.CAPTURE_GROUP;
    }

    private Node handleGroupEndCharacter(int startPos, StringBuilder sb, List<Node> nodes, boolean isChoice, List<Node> choices, Integer captureGroupIndex, GroupType groupType) {
        if (sb.length() == 0 && nodes.isEmpty()) {
            FinalSymbol finalSymbol = new FinalSymbol("");
            this.aNodesStartPos.put(finalSymbol, startPos);
            nodes.add(finalSymbol);
        } else {
            this.sbToFinal(sb, nodes);
        }
        if (isChoice) {
            choices.add(this.sequenceOrNot(startPos, nodes, choices, false, null));
            nodes.clear();
        }
        Node node = this.sequenceOrNot(startPos, nodes, choices, isChoice, captureGroupIndex);
        if (groupType.isNegative()) {
            return new NotSymbol(node.getPattern(), node);
        }
        return node;
    }

    private Node parseGroup(int groupStartPos, GroupType currentGroupType) {
        Integer captureGroupIndex = null;
        if (currentGroupType == GroupType.CAPTURE_GROUP) {
            captureGroupIndex = this.aNextGroupIndex++;
        }
        ArrayList<Node> choices = new ArrayList<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        StringBuilder sb = new StringBuilder(this.aCharIterator.remaining());
        boolean isChoice = false;
        int choicesStartPos = groupStartPos;
        block9: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next().charValue();
            switch (c) {
                case '[': {
                    this.sbToFinal(sb, nodes);
                    nodes.add(this.handleCharacterVariations());
                    continue block9;
                }
                case '(': {
                    this.sbToFinal(sb, nodes);
                    int intGroupStartPos = this.aCharIterator.pos();
                    GroupType groupType = this.processGroupType();
                    nodes.add(this.parseGroup(intGroupStartPos, groupType));
                    continue block9;
                }
                case '|': {
                    choicesStartPos = this.handlePipeCharacter(choices, nodes, sb, choicesStartPos);
                    isChoice = true;
                    continue block9;
                }
                case ')': {
                    return this.handleGroupEndCharacter(groupStartPos, sb, nodes, isChoice, choices, captureGroupIndex, currentGroupType);
                }
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    this.handleRepeatCharacter(nodes, sb, c);
                    continue block9;
                }
                case '.': {
                    this.handleAnySymbolCharacter(nodes, sb);
                    continue block9;
                }
                case '\\': {
                    this.handleEscapedCharacter(sb, nodes, true);
                    continue block9;
                }
            }
            sb.append(c);
        }
        return this.handleGroupEndCharacter(groupStartPos, sb, nodes, isChoice, choices, captureGroupIndex, currentGroupType);
    }

    private void handleAnySymbolCharacter(List<Node> nodes, StringBuilder sb) {
        this.sbToFinal(sb, nodes);
        SymbolSet symbolSet = new SymbolSet();
        this.aNodesStartPos.put(symbolSet, this.aCharIterator.pos());
        nodes.add(symbolSet);
    }

    private int handlePipeCharacter(List<Node> choices, List<Node> nodes, StringBuilder sb, int choicesStartPos) {
        if (sb.length() == 0 && nodes.isEmpty()) {
            FinalSymbol finalSymbol = new FinalSymbol("");
            this.aNodesStartPos.put(finalSymbol, this.aCharIterator.pos() + 1);
            choices.add(finalSymbol);
        } else {
            this.sbToFinal(sb, nodes);
            choices.add(this.sequenceOrNot(choicesStartPos, nodes, choices, false, null));
            choicesStartPos = this.aCharIterator.pos() + 1;
            nodes.clear();
        }
        return choicesStartPos;
    }

    private void handleRepeatCharacter(List<Node> nodes, StringBuilder sb, char c) {
        Node repeatNode;
        if (sb.length() == 0) {
            repeatNode = nodes.remove(nodes.size() - 1);
        } else {
            char charToRepeat = sb.charAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            this.sbToFinal(sb, nodes);
            repeatNode = new FinalSymbol(String.valueOf(charToRepeat));
            this.aNodesStartPos.put(repeatNode, this.aCharIterator.pos() - 1);
        }
        nodes.add(this.handleRepeat(c, repeatNode));
    }

    private int parseHexadecimal() {
        String hexValue;
        char c = this.aCharIterator.peek();
        if (c == '{') {
            this.aCharIterator.skip();
            hexValue = this.aCharIterator.nextUntil('}');
            this.aCharIterator.skip();
        } else {
            hexValue = this.aCharIterator.next(2);
        }
        return Integer.parseInt(hexValue, 16);
    }

    private void handleGroupReference(boolean groupRefAllowed, Collection<Node> nodes, char firstCharacter) {
        if (!groupRefAllowed) {
            throw new RgxGenParseException("Group ref is not expected here. " + this.aCharIterator.context());
        }
        int startPos = this.aCharIterator.pos() - 1;
        String digitsSubstring = this.aCharIterator.takeWhile(Character::isDigit);
        String groupNumber = firstCharacter + digitsSubstring;
        GroupRef groupRef = new GroupRef('\\' + groupNumber, Integer.parseInt(groupNumber));
        this.aNodesStartPos.put(groupRef, startPos);
        nodes.add(groupRef);
    }

    private void handleEscapedCharacter(StringBuilder sb, List<Node> nodes, boolean groupRefAllowed) {
        char c = this.aCharIterator.next().charValue();
        SymbolSet symbolSet = null;
        switch (c) {
            case 'D': 
            case 'd': {
                this.sbToFinal(sb, nodes);
                symbolSet = new SymbolSet("\\" + c, CONST_PROVIDER.getDigits(), c == 'd' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE);
                break;
            }
            case 'S': 
            case 's': {
                this.sbToFinal(sb, nodes);
                symbolSet = new SymbolSet("\\" + c, CONST_PROVIDER.getWhitespaces(), c == 's' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE);
                break;
            }
            case 'W': 
            case 'w': {
                this.sbToFinal(sb, nodes);
                symbolSet = new SymbolSet("\\" + c, CONST_PROVIDER.getWordCharRanges(), SINGLETON_UNDERSCORE_ARRAY, c == 'w' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE);
                break;
            }
            case 'x': {
                sb.append((char)this.parseHexadecimal());
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.sbToFinal(sb, nodes);
                this.handleGroupReference(groupRefAllowed, nodes, c);
                break;
            }
            default: {
                sb.append(c);
            }
        }
        if (symbolSet != null) {
            this.aNodesStartPos.put(symbolSet, this.aCharIterator.pos() - 1);
            nodes.add(symbolSet);
        }
    }

    private Repeat handleRepeatInCurvyBraces(int startPos, Node repeatNode) {
        StringBuilder sb = new StringBuilder(10);
        int min = -1;
        int contextIndex = this.aCharIterator.pos();
        block9: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next().charValue();
            switch (c) {
                case ',': {
                    int tmpContextIndex = this.aCharIterator.pos() - 1;
                    try {
                        min = Integer.parseInt(sb.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new RgxGenParseException("Malformed lower bound number." + this.aCharIterator.context(tmpContextIndex), e);
                    }
                    sb.delete(0, sb.length());
                    continue block9;
                }
                case '}': {
                    if (min == -1) {
                        return new Repeat(this.aCharIterator.substringToCurrPos(startPos), repeatNode, Integer.parseInt(sb.toString()));
                    }
                    if (sb.length() == 0) {
                        return Repeat.minimum(this.aCharIterator.substringToCurrPos(startPos), repeatNode, min);
                    }
                    try {
                        return new Repeat(this.aCharIterator.substringToCurrPos(startPos), repeatNode, min, Integer.parseInt(sb.toString()));
                    }
                    catch (NumberFormatException e) {
                        throw new RgxGenParseException("Malformed upper bound number." + this.aCharIterator.context(), e);
                    }
                }
                case '\\': {
                    throw new RgxGenParseException("Escape character inside curvy repetition is not supported. " + this.aCharIterator.context());
                }
            }
            sb.append(c);
        }
        throw new RgxGenParseException("Unbalanced '{' - missing '}' at " + this.aCharIterator.context(contextIndex));
    }

    private Repeat handleRepeat(char c, Node repeatNode) {
        int startPos = this.aNodesStartPos.get(repeatNode);
        Repeat node = null;
        switch (c) {
            case '*': {
                node = Repeat.minimum(this.aCharIterator.substringToCurrPos(startPos), repeatNode, 0);
                break;
            }
            case '?': {
                node = new Repeat(this.aCharIterator.substringToCurrPos(startPos), repeatNode, 0, 1);
                break;
            }
            case '+': {
                node = Repeat.minimum(this.aCharIterator.substringToCurrPos(startPos), repeatNode, 1);
                break;
            }
            case '{': {
                node = this.handleRepeatInCurvyBraces(startPos, repeatNode);
                break;
            }
            default: {
                throw new RgxGenParseException("Unknown repetition character '" + c + '\'' + this.aCharIterator.context());
            }
        }
        this.aNodesStartPos.put(node, startPos);
        return node;
    }

    private Node sequenceOrNot(int startPos, List<Node> nodes, List<Node> choices, boolean isChoice, Integer captureGroupIndex) {
        Node resultNode;
        if (nodes.size() == 1) {
            resultNode = nodes.get(0);
        } else if (isChoice) {
            if (choices.isEmpty()) {
                throw new RuntimeException("Empty nodes");
            }
            resultNode = new Choice(this.aCharIterator.substringToCurrPos(startPos), choices.toArray(EMPTY_NODES_ARR));
        } else {
            if (nodes.isEmpty()) {
                throw new RuntimeException("Empty nodes");
            }
            resultNode = new Sequence(this.aCharIterator.substringToCurrPos(startPos), nodes.toArray(EMPTY_NODES_ARR));
        }
        this.aNodesStartPos.put(resultNode, startPos);
        if (captureGroupIndex == null) {
            return resultNode;
        }
        Group group = new Group(this.aCharIterator.substringToCurrPos(startPos), captureGroupIndex, resultNode);
        this.aNodesStartPos.put(group, startPos);
        return group;
    }

    private static void handleRange(boolean rangeStarted, StringBuilder sb, List<SymbolSet.SymbolRange> symbolRanges) {
        if (rangeStarted) {
            char lastChar = sb.charAt(sb.length() - 1);
            char firstChar = sb.charAt(sb.length() - 2);
            sb.delete(sb.length() - 2, sb.length());
            symbolRanges.add(new SymbolSet.SymbolRange(firstChar, lastChar));
        }
    }

    private boolean handleBackslashCharacter(boolean rangeStarted, StringBuilder sb, List<SymbolSet.SymbolRange> symbolRanges) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        if (rangeStarted) {
            this.handleEscapedCharacter(sb, nodes, false);
            if (!nodes.isEmpty()) {
                throw new RgxGenParseException("Cannot make range with a shorthand escape sequences before '" + this.aCharIterator.context() + '\'');
            }
            DefaultTreeBuilder.handleRange(true, sb, symbolRanges);
        } else {
            StringBuilder tmpSb = new StringBuilder(0);
            this.handleEscapedCharacter(tmpSb, nodes, false);
            sb.append((CharSequence)tmpSb);
        }
        if (!nodes.isEmpty()) {
            if (nodes.size() > 1) {
                throw new RgxGenParseException("Multiple nodes found inside square brackets escape sequence before '" + this.aCharIterator.context() + '\'');
            }
            if (nodes.get(0) instanceof SymbolSet) {
                for (String symbol : ((SymbolSet)nodes.get(0)).getSymbols()) {
                    sb.append(symbol);
                }
            } else {
                throw new RgxGenParseException("Unexpected node found inside square brackets escape sequence before '" + this.aCharIterator.context() + '\'');
            }
        }
        return false;
    }

    private Node handleCharacterVariations() {
        int openSquareBraceIndex = this.aCharIterator.pos();
        SymbolSet.TYPE symbolSetType = SymbolSet.TYPE.POSITIVE;
        if (this.aCharIterator.peek() == '^') {
            symbolSetType = SymbolSet.TYPE.NEGATIVE;
            this.aCharIterator.next();
        }
        StringBuilder sb = new StringBuilder(this.aCharIterator.remaining());
        LinkedList<SymbolSet.SymbolRange> symbolRanges = new LinkedList<SymbolSet.SymbolRange>();
        boolean rangeStarted = false;
        block5: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next().charValue();
            switch (c) {
                case ']': {
                    return this.handleEndCharacterVariationsCharacter(openSquareBraceIndex, symbolSetType, sb, symbolRanges, rangeStarted);
                }
                case '-': {
                    if (this.aCharIterator.peek() == ']' || this.aCharIterator.peek(-2) == '[') {
                        sb.append(c);
                        continue block5;
                    }
                    rangeStarted = true;
                    continue block5;
                }
                case '\\': {
                    rangeStarted = this.handleBackslashCharacter(rangeStarted, sb, symbolRanges);
                    continue block5;
                }
            }
            sb.append(c);
            DefaultTreeBuilder.handleRange(rangeStarted, sb, symbolRanges);
            rangeStarted = false;
        }
        throw new RgxGenParseException("Unexpected End Of Expression. Didn't find closing ']'" + this.aCharIterator.context(openSquareBraceIndex));
    }

    private SymbolSet handleEndCharacterVariationsCharacter(int openSquareBraceIndex, SymbolSet.TYPE symbolSetType, StringBuilder sb, List<SymbolSet.SymbolRange> symbolRanges, boolean rangeStarted) {
        DefaultTreeBuilder.handleRange(rangeStarted, sb, symbolRanges);
        String[] strings = sb.length() == 0 ? EMPTY_STRINGS_ARR : Util.stringToCharsSubstrings(sb.toString());
        SymbolSet symbolSet = new SymbolSet(this.aCharIterator.substringToCurrPos(openSquareBraceIndex), symbolRanges, strings, symbolSetType);
        this.aNodesStartPos.put(symbolSet, openSquareBraceIndex);
        return symbolSet;
    }

    public void build() {
        if (this.aCharIterator.peek() == '^') {
            this.aCharIterator.next();
        }
        if (this.aCharIterator.last() == '$') {
            this.aCharIterator.setBound(-1);
        }
        this.aNode = this.parseGroup(this.aCharIterator.pos() + 1, GroupType.NON_CAPTURE_GROUP);
        if (this.aCharIterator.hasNext()) {
            throw new RgxGenParseException("Expression was not fully parsed: " + this.aCharIterator.context());
        }
    }

    @Override
    public Node get() {
        if (this.aNode == null) {
            this.build();
        }
        return this.aNode;
    }

    private static class ConstantsProvider {
        private String[] aDigits;
        private String[] aWhiteSpaces;
        private List<SymbolSet.SymbolRange> aWordCharRanges;

        private ConstantsProvider() {
        }

        String[] getDigits() {
            if (this.aDigits == null) {
                this.aDigits = (String[])IntStream.rangeClosed(0, 9).mapToObj(Integer::toString).toArray(String[]::new);
            }
            return this.aDigits;
        }

        String[] getWhitespaces() {
            if (this.aWhiteSpaces == null) {
                this.aWhiteSpaces = new String[]{"\r", "\f", "\u000b", " ", "\t", "\n"};
            }
            return this.aWhiteSpaces;
        }

        List<SymbolSet.SymbolRange> getWordCharRanges() {
            if (this.aWordCharRanges == null) {
                this.aWordCharRanges = Collections.unmodifiableList(Arrays.asList(SymbolSet.SymbolRange.SMALL_LETTERS, SymbolSet.SymbolRange.CAPITAL_LETTERS, SymbolSet.SymbolRange.DIGITS));
            }
            return this.aWordCharRanges;
        }
    }

    private static enum GroupType {
        POSITIVE_LOOKAHEAD,
        NEGATIVE_LOOKAHEAD,
        POSITIVE_LOOKBEHIND,
        NEGATIVE_LOOKBEHIND,
        CAPTURE_GROUP,
        NON_CAPTURE_GROUP;


        public boolean isNegative() {
            return this == NEGATIVE_LOOKAHEAD || this == NEGATIVE_LOOKBEHIND;
        }
    }
}

