/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators.suppliers;

import com.github.curiousoddman.rgxgen.iterators.ReferenceIterator;
import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupIteratorSupplier
implements Supplier<StringIterator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupIteratorSupplier.class);
    private final Supplier<StringIterator> aIteratorSupplier;
    private final Map<Integer, List<ReferenceIterator>> aReferenceIteratorMap;
    private final Map<Integer, StringIterator> aGroupIteratorsMap;
    private final int aIndex;

    public GroupIteratorSupplier(Supplier<StringIterator> iteratorSupplier, Map<Integer, List<ReferenceIterator>> referenceIteratorMap, Map<Integer, StringIterator> groupIteratorsMap, int index) {
        this.aIteratorSupplier = iteratorSupplier;
        this.aReferenceIteratorMap = referenceIteratorMap;
        this.aGroupIteratorsMap = groupIteratorsMap;
        this.aIndex = index;
        LOGGER.trace("Creating idx {}\n\tsrc: {}\n\trefs: {}\n\tgrps: {}", new Object[]{index, iteratorSupplier, referenceIteratorMap, groupIteratorsMap});
    }

    @Override
    public StringIterator get() {
        LOGGER.trace("Getting idx {}\n\trefs: {}\n\tgrps: {}", new Object[]{this.aIndex, this.aReferenceIteratorMap, this.aGroupIteratorsMap});
        StringIterator stringIterator = this.aIteratorSupplier.get();
        this.aGroupIteratorsMap.put(this.aIndex, stringIterator);
        List orDefault = this.aReferenceIteratorMap.getOrDefault(this.aIndex, Collections.emptyList());
        LOGGER.debug("ReferenceIterators to connect: {}", orDefault);
        for (ReferenceIterator referenceIterator : orDefault) {
            LOGGER.debug("GroupRef[{}] connecting to group {} ", (Object)this.aIndex, (Object)stringIterator);
            referenceIterator.setOther(stringIterator);
        }
        return stringIterator;
    }

    public String toString() {
        return "GroupIteratorSupplier{aIteratorSupplier=" + this.aIteratorSupplier + ", aReferenceIteratorMap=" + this.aReferenceIteratorMap + ", aGroupIterators=" + this.aGroupIteratorsMap + ", aIndex=" + this.aIndex + '}';
    }
}

