/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.StringUtil;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class BaseModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Long userId;
    private String date;

    public Long getId() {
        return this.id;
    }

    public BaseModel setId(Long id) {
        this.id = id;
        return this;
    }

    public Long getUserId() {
        return this.userId;
    }

    public BaseModel setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public String getDate() {
        return this.date;
    }

    public BaseModel setDate(String date) {
        this.date = date;
        return this;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public static Timestamp currentTimeStamp() {
        return new Timestamp(new Date().getTime());
    }

    public static Timestamp getTimeStamp(String time) {
        return Timestamp.valueOf(time);
    }

    public static long getTimeMillis(String time) {
        return StringUtil.isEmpty((String)time, (boolean)true) ? 0L : BaseModel.getTimeStamp(time).getTime();
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length <= 0;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <T> boolean isContain(T[] array, T a) {
        return array == null ? false : Arrays.asList(array).contains(a);
    }

    public static <T> boolean isContain(Collection<T> collection, T object) {
        return collection != null && collection.contains(object);
    }

    public static <K, V> boolean isContainKey(Map<K, V> map, K key) {
        return map != null && map.containsKey(key);
    }

    public static <K, V> boolean isContainValue(Map<K, V> map, V value) {
        return map != null && map.containsValue(value);
    }

    public static <T> int count(T[] array) {
        return array == null ? 0 : array.length;
    }

    public static <T> int count(Collection<T> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static <K, V> int count(Map<K, V> map) {
        return map == null ? 0 : map.size();
    }

    public static <T> T get(T[] array, int position) {
        return position < 0 || position >= BaseModel.count(array) ? null : (T)array[position];
    }

    public static <T> T get(Collection<T> collection, int position) {
        return (T)(collection == null ? null : BaseModel.get(collection.toArray(), position));
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        return key == null || map == null ? null : (V)map.get(key);
    }

    public static boolean value(Boolean value) {
        return value == null ? false : value;
    }

    public static int value(Integer value) {
        return value == null ? 0 : value;
    }

    public static long value(Long value) {
        return value == null ? 0L : value;
    }

    public static float value(Float value) {
        return value == null ? 0.0f : value.floatValue();
    }

    public static double value(Double value) {
        return value == null ? 0.0 : value;
    }

    public static boolean isIndexInRange(Integer index, Object[] array) {
        return index != null && index >= 0 && index < BaseModel.count(array);
    }

    public static int getIndexInRange(Integer index, Object[] array) {
        return BaseModel.getIndexInRange(index, array, 0);
    }

    public static int getIndexInRange(Integer index, Object[] array, int defaultIndex) {
        return BaseModel.isIndexInRange(index, array) ? index : defaultIndex;
    }

    public static <T> T getInRange(Integer index, T[] array) {
        return BaseModel.getInRange(index, array, 0);
    }

    public static <T> T getInRange(Integer index, T[] array, int defaultIndex) {
        return BaseModel.get(array, BaseModel.getIndexInRange(index, array, defaultIndex));
    }
}

