/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.List;
import net.jradius.dictionary.Attr_CleartextPassword;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.exception.RadiusException;
import net.jradius.handler.PacketHandlerBase;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.server.JRadiusRequest;
import net.jradius.server.config.ConfigurationItem;
import net.jradius.server.config.XMLConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class LocalUsersHandler
extends PacketHandlerBase {
    private final LinkedHashMap<String, LocalUser> users = new LinkedHashMap();

    public void setConfig(ConfigurationItem cfg) {
        super.setConfig(cfg);
        HierarchicalConfiguration.Node root = cfg.getRoot();
        XMLConfiguration xmlCfg = cfg.getXMLConfig();
        List usersList = root.getChildren("users");
        for (HierarchicalConfiguration.Node node2 : usersList) {
            List children = node2.getChildren("user");
            for (HierarchicalConfiguration.Node node2 : children) {
                root = xmlCfg.getRoot();
                xmlCfg.setRoot(node2);
                LocalUser user = new LocalUser();
                user.username = xmlCfg.getString("[@username]");
                user.realm = xmlCfg.getString("[@realm]");
                user.password = xmlCfg.getString("[@password]");
                Object v = node2.getValue();
                if (v != null) {
                    user.attributes = v.toString();
                }
                RadiusLog.debug((String)("        -> Configured local user: " + user.getUserName()));
                this.users.put(user.getUserName(), user);
                xmlCfg.setRoot(root);
            }
        }
    }

    public boolean handle(JRadiusRequest jRequest) {
        try {
            int type = jRequest.getType();
            AttributeList ci = jRequest.getConfigItems();
            RadiusPacket req = jRequest.getRequestPacket();
            RadiusPacket rep = jRequest.getReplyPacket();
            String username = (String)req.getAttributeValue(1L);
            LocalUser u = this.users.get(username);
            if (u == null) {
                RadiusLog.info((String)("Ignoring unknown username: " + username));
                return false;
            }
            switch (type) {
                case 2: {
                    ci.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)u.password)));
                    ci.add((RadiusAttribute)new Attr_CleartextPassword((Serializable)((Object)u.password)));
                    break;
                }
                case 8: {
                    if (rep instanceof AccessAccept) {
                        rep.addAttributes(u.getAttributeList());
                        break;
                    }
                    RadiusLog.info((String)("Authentication failed for username: " + username));
                }
            }
        }
        catch (RadiusException e) {
            e.printStackTrace();
        }
        jRequest.setReturnValue(8);
        return false;
    }

    private class LocalUser {
        public String username;
        public String realm;
        public String password;
        public String attributes;
        public AttributeList attrList;

        private LocalUser() {
        }

        public String getUserName() {
            if (this.realm != null) {
                return this.username + "@" + this.realm;
            }
            return this.username;
        }

        public AttributeList getAttributeList() {
            if (this.attrList == null && this.attributes != null) {
                BufferedReader in = new BufferedReader(new StringReader(this.attributes));
                this.attrList = new AttributeList();
                block4: while (true) {
                    try {
                        String line;
                        while ((line = in.readLine()) != null) {
                            String[] parts;
                            if ((line = line.trim()).equals("") || (parts = line.split("[^a-zA-Z-]", 2)).length != 2) continue;
                            String attribute = parts[0];
                            line = parts[1].trim();
                            if ((parts = line.split("[^\\+=:-]", 2)).length != 2) continue;
                            String op = parts[0];
                            String value = parts[1];
                            try {
                                RadiusAttribute attr = AttributeFactory.newAttribute((String)attribute, (String)value, (String)op);
                                if (attr == null) continue block4;
                                this.attrList.add(attr, false);
                                continue block4;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
            return this.attrList;
        }
    }
}

