/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.example;

import java.io.Serializable;
import java.net.InetAddress;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_AcctInputOctets;
import net.jradius.dictionary.Attr_AcctOutputOctets;
import net.jradius.dictionary.Attr_AcctSessionId;
import net.jradius.dictionary.Attr_AcctSessionTime;
import net.jradius.dictionary.Attr_AcctStatusType;
import net.jradius.dictionary.Attr_AcctTerminateCause;
import net.jradius.dictionary.Attr_NASPort;
import net.jradius.dictionary.Attr_NASPortType;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.util.RadiusRandom;

public class ExampleRadiusClient {
    public static void main(String[] args) {
        try {
            AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
            InetAddress host = InetAddress.getByName("localhost");
            RadiusClient rc = new RadiusClient(host, "test", 1812, 1813, 1000);
            AttributeList attrs = new AttributeList();
            attrs.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)"test")));
            attrs.add((RadiusAttribute)new Attr_NASPortType((Serializable)Attr_NASPortType.Wireless80211));
            attrs.add((RadiusAttribute)new Attr_NASPort((Serializable)new Long(1L)));
            AccessRequest request = new AccessRequest(rc, attrs);
            request.addAttribute((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)"test")));
            System.out.println("Sending:\n" + request.toString());
            RadiusResponse reply = rc.authenticate(request, (RadiusAuthenticator)new MSCHAPv2Authenticator(), 5);
            System.out.println("Received:\n" + reply.toString());
            boolean isAuthenticated = reply instanceof AccessAccept;
            String replyMessage = (String)reply.getAttributeValue(18L);
            if (replyMessage != null) {
                System.out.println("Reply Message: " + replyMessage);
            }
            if (!isAuthenticated) {
                return;
            }
            attrs.add((RadiusAttribute)new Attr_AcctSessionId((Serializable)((Object)RadiusRandom.getRandomString((int)24))));
            request = new AccountingRequest(rc, attrs);
            request.addAttribute((RadiusAttribute)new Attr_AcctStatusType((Serializable)((Object)"Start")));
            System.out.println("Sending:\n" + request.toString());
            reply = rc.accounting((AccountingRequest)request, 5);
            System.out.println("Received:\n" + reply.toString());
            request = new AccountingRequest(rc, attrs);
            request.addAttribute((RadiusAttribute)new Attr_AcctStatusType((Serializable)((Object)"Interim-Update")));
            request.addAttribute((RadiusAttribute)new Attr_AcctInputOctets((Serializable)new Long(42949670L)));
            request.addAttribute((RadiusAttribute)new Attr_AcctOutputOctets((Serializable)new Long(5L)));
            request.addAttribute((RadiusAttribute)new Attr_AcctSessionTime((Serializable)new Long(10L)));
            System.out.println("Sending:\n" + request.toString());
            reply = rc.accounting((AccountingRequest)request, 5);
            System.out.println("Received:\n" + reply.toString());
            request = new AccountingRequest(rc, attrs);
            request.addAttribute((RadiusAttribute)new Attr_AcctStatusType((Serializable)((Object)"Interim-Update")));
            request.addAttribute((RadiusAttribute)new Attr_AcctInputOctets((Serializable)new Long(429496700L)));
            request.addAttribute((RadiusAttribute)new Attr_AcctOutputOctets((Serializable)new Long(5L)));
            request.addAttribute((RadiusAttribute)new Attr_AcctSessionTime((Serializable)new Long(30L)));
            System.out.println("Sending:\n" + request.toString());
            reply = rc.accounting((AccountingRequest)request, 5);
            System.out.println("Received:\n" + reply.toString());
            request = new AccountingRequest(rc, attrs);
            request.addAttribute((RadiusAttribute)new Attr_AcctStatusType((Serializable)((Object)"Stop")));
            request.addAttribute((RadiusAttribute)new Attr_AcctInputOctets((Serializable)new Long(4294967000L)));
            request.addAttribute((RadiusAttribute)new Attr_AcctOutputOctets((Serializable)new Long(10L)));
            request.addAttribute((RadiusAttribute)new Attr_AcctSessionTime((Serializable)new Long(60L)));
            request.addAttribute((RadiusAttribute)new Attr_AcctTerminateCause((Serializable)Attr_AcctTerminateCause.UserRequest));
            System.out.println("Sending:\n" + request.toString());
            reply = rc.accounting((AccountingRequest)request, 5);
            System.out.println("Received:\n" + reply.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

