/*
 * Decompiled with CFR 0.152.
 */
package com.clk.progress;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.clk.progress.R;
import java.util.Timer;
import java.util.TimerTask;

public class CircularProgress
extends View {
    private static final String TAG = "clk_CircularProgress";
    private Activity activity;
    private Canvas canvas;
    private Paint paintBody;
    private Paint paintFirst;
    private Paint paintSecond;
    private Paint paintTransparent;
    private int bodyColor = this.getContext().getResources().getColor(R.color.white);
    private int firstColor = this.getContext().getResources().getColor(R.color.blue);
    private int secondColor = this.getContext().getResources().getColor(R.color.green);
    private int thirdColor = this.getContext().getResources().getColor(R.color.pink);
    private int fourthColor = this.getContext().getResources().getColor(R.color.orange);
    private int rotation_speeed = 15;
    private int sweepAngle = 120;
    int startBlueAngle = 60;
    int startGreenAngle = 240;
    int fast = 10;
    int turn = 0;
    int color = 0;

    public CircularProgress(Activity activity) {
        super((Context)activity);
        this.activity = activity;
        this.init(null);
    }

    public void setColor(int firstColor, int secondColor, int thirdColor, int fourthColor) {
        this.firstColor = firstColor;
        this.secondColor = secondColor;
        this.thirdColor = thirdColor;
        this.fourthColor = fourthColor;
    }

    public void setBodyColor(int bodyColor) {
        this.bodyColor = bodyColor;
    }

    public void setRotationSpeeed(int speed) {
        this.rotation_speeed = speed;
    }

    private void init(@Nullable AttributeSet set) {
        this.bodyColor = this.getContext().getResources().getColor(R.color.white);
        this.firstColor = this.getContext().getResources().getColor(R.color.blue);
        this.secondColor = this.getContext().getResources().getColor(R.color.green);
        this.fourthColor = this.getContext().getResources().getColor(R.color.orange);
        this.thirdColor = this.getContext().getResources().getColor(R.color.pink);
        this.paintBody = new Paint(1);
        this.paintBody.setColor(this.bodyColor);
        this.paintTransparent = new Paint(1);
        this.paintTransparent.setColor(this.getContext().getResources().getColor(R.color.transparent));
        this.paintFirst = new Paint(1);
        this.paintFirst.setColor(this.firstColor);
        this.paintSecond = new Paint(1);
        this.paintSecond.setColor(this.secondColor);
        this.swapColor();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.canvas = canvas;
        canvas.drawColor(0);
        RectF oval = new RectF();
        int width = this.getWidth();
        int height = this.getHeight();
        int center_x = width / 2;
        int center_y = height / 2;
        int left = width / 10;
        int top = height / 10;
        int right = width - left;
        int bottom = height - top;
        int radius = width / 2 - (left + left / 2);
        oval.set((float)left, (float)top, (float)right, (float)bottom);
        canvas.drawArc(oval, (float)this.startBlueAngle, (float)this.sweepAngle, true, this.paintFirst);
        canvas.drawArc(oval, (float)this.startGreenAngle, (float)this.sweepAngle, true, this.paintSecond);
        canvas.drawCircle((float)center_x, (float)center_y, (float)radius, this.paintBody);
    }

    private void swapColor() {
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                CircularProgress.this.startBlueAngle += CircularProgress.this.fast;
                CircularProgress.this.startGreenAngle += CircularProgress.this.fast;
                if (CircularProgress.this.startBlueAngle > 359) {
                    CircularProgress.this.startBlueAngle = 0;
                    ++CircularProgress.this.turn;
                    ++CircularProgress.this.color;
                    if (CircularProgress.this.turn > 2) {
                        CircularProgress.this.turn = 0;
                    }
                } else if (CircularProgress.this.startBlueAngle > 150 && CircularProgress.this.turn < 1) {
                    CircularProgress.this.fast = 3;
                } else if (CircularProgress.this.startBlueAngle < 270) {
                    CircularProgress.this.fast = CircularProgress.this.rotation_speeed;
                }
                if (CircularProgress.this.startGreenAngle > 359) {
                    CircularProgress.this.startGreenAngle = 0;
                }
                CircularProgress.this.paintBody.setColor(CircularProgress.this.bodyColor);
                if (CircularProgress.this.color == 0) {
                    CircularProgress.this.paintFirst.setColor(CircularProgress.this.firstColor);
                    CircularProgress.this.paintSecond.setColor(CircularProgress.this.secondColor);
                } else if (CircularProgress.this.color == 2) {
                    CircularProgress.this.paintFirst.setColor(CircularProgress.this.firstColor);
                    CircularProgress.this.paintSecond.setColor(CircularProgress.this.fourthColor);
                } else if (CircularProgress.this.color == 4) {
                    CircularProgress.this.paintFirst.setColor(CircularProgress.this.secondColor);
                    CircularProgress.this.paintSecond.setColor(CircularProgress.this.fourthColor);
                } else if (CircularProgress.this.color == 6) {
                    CircularProgress.this.paintFirst.setColor(CircularProgress.this.thirdColor);
                    CircularProgress.this.paintSecond.setColor(CircularProgress.this.firstColor);
                } else if (CircularProgress.this.color == 8) {
                    CircularProgress.this.color = -1;
                }
                CircularProgress.this.postInvalidate();
            }
        }, 5L, 10L);
    }

    public CircularProgress(Context activity, @Nullable AttributeSet attrs) {
        super(activity, attrs);
        this.init(attrs);
    }

    public CircularProgress(Context activity, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(activity, attrs, defStyleAttr);
        this.init(attrs);
    }

    @RequiresApi(api=21)
    public CircularProgress(Context activity, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(activity, attrs, defStyleAttr, defStyleRes);
    }
}

