/*
 * Decompiled with CFR 0.152.
 */
package com.claudiodegio.msv;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.claudiodegio.msv.BaseMaterialSearchView;
import com.claudiodegio.msv.OnFilterViewListener;
import com.claudiodegio.msv.R;
import com.claudiodegio.msv.adapter.FilterRvAdapter;
import com.claudiodegio.msv.adapter.SelectFilterRvAdapter;
import com.claudiodegio.msv.model.BaseElement;
import com.claudiodegio.msv.model.Filter;
import com.claudiodegio.msv.model.Section;
import com.claudiodegio.msv.recycleview.RecyclerItemClickListener;
import java.util.List;

public class FilterMaterialSearchView
extends BaseMaterialSearchView
implements RecyclerItemClickListener.OnItemClickListener {
    private RecyclerView mRvFilter;
    private RecyclerView mRvSelectFilter;
    private SelectFilterRvAdapter mSelectFilterRvAdapter;
    private FilterRvAdapter mFilterRvAdapter;
    private OnFilterViewListener mOnFilterViewListener;
    private TextView mTvNoFilter;
    private boolean isContainFilter;

    public FilterMaterialSearchView(Context context) {
        super(context, null);
    }

    public FilterMaterialSearchView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FilterMaterialSearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initStyle(attrs, defStyleAttr);
        this.initView();
    }

    @Override
    protected int getLayoutId() {
        return R.layout.msv_filter;
    }

    public void addSection(Section section) {
        this.mSelectFilterRvAdapter.addElement(section);
    }

    public void addFilter(Filter filter) {
        this.mSelectFilterRvAdapter.addElement(filter);
    }

    public void swapList(List<BaseElement> list) {
        this.mSelectFilterRvAdapter.swapList(list);
    }

    public List<Filter> getFilter() {
        return this.mFilterRvAdapter.getFilters();
    }

    public String getQuery() {
        return this.mETSearchText.getText().toString();
    }

    private void initView() {
        this.mRvFilter = (RecyclerView)this.findViewById(R.id.rv_filter);
        this.mRvSelectFilter = (RecyclerView)this.findViewById(R.id.rv_select_filter);
        this.mTvNoFilter = (TextView)this.findViewById(R.id.tv_no_filter);
        this.mSelectFilterRvAdapter = new SelectFilterRvAdapter(this.getContext(), this.isContainFilter);
        this.mRvSelectFilter.setHasFixedSize(false);
        this.mRvSelectFilter.setAdapter((RecyclerView.Adapter)this.mSelectFilterRvAdapter);
        this.mRvSelectFilter.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener(this.getContext(), this));
        this.mFilterRvAdapter = new FilterRvAdapter(this.getContext());
        this.mRvFilter.setHasFixedSize(false);
        this.mRvFilter.setAdapter((RecyclerView.Adapter)this.mFilterRvAdapter);
        this.mRvFilter.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener(this.getContext(), this));
        GridLayoutManager gridLayoutManager = new GridLayoutManager(this.getContext(), 1, 0, false);
        this.mRvFilter.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.mFilterRvAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                if (FilterMaterialSearchView.this.mFilterRvAdapter.getItemCount() == 0) {
                    FilterMaterialSearchView.this.mTvNoFilter.setVisibility(0);
                } else {
                    FilterMaterialSearchView.this.mTvNoFilter.setVisibility(8);
                }
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                if (FilterMaterialSearchView.this.mFilterRvAdapter.getItemCount() == 0) {
                    FilterMaterialSearchView.this.mTvNoFilter.setVisibility(0);
                } else {
                    FilterMaterialSearchView.this.mTvNoFilter.setVisibility(8);
                }
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                if (FilterMaterialSearchView.this.mFilterRvAdapter.getItemCount() == 0) {
                    FilterMaterialSearchView.this.mTvNoFilter.setVisibility(0);
                } else {
                    FilterMaterialSearchView.this.mTvNoFilter.setVisibility(8);
                }
            }
        });
    }

    @Override
    public void showSearch(boolean animate) {
        super.showSearch(animate);
        this.showSelectFilter();
        this.mFilterRvAdapter.clear();
    }

    @Override
    public void closeSearch() {
        super.closeSearch();
        this.mFilterRvAdapter.clear();
    }

    private void showSelectFilter() {
        this.mRvSelectFilter.setVisibility(0);
    }

    private void hideSelectFilter() {
        this.mRvSelectFilter.setVisibility(8);
    }

    public boolean isFilterVisible() {
        return this.mRvFilter.getVisibility() == 0;
    }

    public int getFilterHeight() {
        return this.mRvFilter.getHeight();
    }

    @Override
    public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
        Log.d((String)"BMSV", (String)("onEditorAction: " + actionId));
        if (actionId == 3) {
            this.hideSelectFilter();
            return super.onEditorAction(textView, actionId, keyEvent);
        }
        return false;
    }

    @Override
    public void onClick(View view) {
        if (view == this.mETSearchText && this.mRvSelectFilter.getVisibility() == 8) {
            this.showSelectFilter();
            this.hideKeyboard((View)this.mETSearchText);
            return;
        }
        super.onClick(view);
    }

    @Override
    public void onItemClick(RecyclerView rv, View view, int position) {
        Log.d((String)"BMSV", (String)("onItemClick: position:" + position));
        if (rv == this.mRvSelectFilter) {
            BaseElement element = this.mSelectFilterRvAdapter.getItem(position);
            if (element instanceof Filter) {
                this.mFilterRvAdapter.addFilter((Filter)element);
                this.hideSelectFilter();
                this.hideKeyboard((View)this.mETSearchText);
                this.mETSearchText.setText(null);
                if (this.mOnFilterViewListener != null) {
                    this.mOnFilterViewListener.onFilterAdded((Filter)element);
                }
            }
        } else {
            Filter filter = this.mFilterRvAdapter.removeFilter(position);
            if (this.mFilterRvAdapter.getItemCount() == 0) {
                this.showSelectFilter();
            }
            if (this.mOnFilterViewListener != null) {
                this.mOnFilterViewListener.onFilterRemoved(filter);
            }
        }
        if (this.mOnFilterViewListener != null) {
            this.mOnFilterViewListener.onFilterChanged(this.mFilterRvAdapter.getFilters());
        }
    }

    private void startFilter(String text) {
        this.mSelectFilterRvAdapter.getFilter().filter((CharSequence)text);
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        super.onTextChanged(charSequence, i, i1, i2);
        this.startFilter(charSequence.toString());
    }

    public void setOnFilterViewListener(OnFilterViewListener mOnFilterViewListener) {
        this.mOnFilterViewListener = mOnFilterViewListener;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof FilterMSVSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        FilterMSVSavedState mSavedState = (FilterMSVSavedState)state;
        super.onRestoreInstanceState(mSavedState.getSuperState());
        if (mSavedState.isFilterSelectOpen) {
            this.showSelectFilter();
        } else {
            this.hideSelectFilter();
        }
        this.mFilterRvAdapter.setFilters(mSavedState.filters);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        FilterMSVSavedState savedState = new FilterMSVSavedState(super.onSaveInstanceState());
        savedState.isFilterSelectOpen = this.mRvSelectFilter.getVisibility() == 0;
        savedState.filters = this.mFilterRvAdapter.getFilters();
        return savedState;
    }

    private void initStyle(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Msv, defStyleAttr, 0);
        if (a != null) {
            if (a.hasValue(R.styleable.Msv_msvIsContainEnabled)) {
                this.isContainFilter = a.getBoolean(R.styleable.Msv_msvIsContainEnabled, false);
            }
            a.recycle();
        }
    }

    class FilterMSVSavedState
    extends View.BaseSavedState {
        public boolean isFilterSelectOpen;
        public List<Filter> filters;

        public FilterMSVSavedState(Parcelable superState) {
            super(superState);
        }
    }
}

