/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.content.Context;
import com.chuckerteam.chucker.internal.data.entity.HttpHeader;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.Sharable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/chuckerteam/chucker/internal/support/TransactionCurlCommandSharable;", "Lcom/chuckerteam/chucker/internal/support/Sharable;", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "<init>", "(Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;)V", "toSharableContent", "Lokio/Source;", "context", "Landroid/content/Context;", "isCompressed", "", "header", "Lcom/chuckerteam/chucker/internal/data/entity/HttpHeader;", "escapeHeaderValue", "", "value", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nTransactionCurlCommandSharable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionCurlCommandSharable.kt\ncom/chuckerteam/chucker/internal/support/TransactionCurlCommandSharable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1869#2,2:47\n*S KotlinDebug\n*F\n+ 1 TransactionCurlCommandSharable.kt\ncom/chuckerteam/chucker/internal/support/TransactionCurlCommandSharable\n*L\n18#1:47,2\n*E\n"})
public final class TransactionCurlCommandSharable
implements Sharable {
    @NotNull
    private final HttpTransaction transaction;

    public TransactionCurlCommandSharable(@NotNull HttpTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.transaction = transaction;
    }

    @Override
    @NotNull
    public Source toSharableContent(@NotNull Context context) {
        String requestBody;
        CharSequence charSequence;
        List<HttpHeader> headers;
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Buffer $this$toSharableContent_u24lambda_u241 = buffer = new Buffer();
        boolean bl = false;
        boolean compressed = false;
        $this$toSharableContent_u24lambda_u241.writeUtf8("curl -X " + this.transaction.getMethod());
        List<HttpHeader> list = headers = this.transaction.getParsedRequestHeaders();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HttpHeader header = (HttpHeader)element$iv;
                boolean bl2 = false;
                if (this.isCompressed(header)) {
                    compressed = true;
                }
                String headerValue = this.escapeHeaderValue(header.getValue());
                $this$toSharableContent_u24lambda_u241.writeUtf8(" -H \"" + header.getName() + ": " + headerValue + "\"");
            }
        }
        if (!((charSequence = (CharSequence)(requestBody = this.transaction.getRequestBody())) == null || charSequence.length() == 0)) {
            $this$toSharableContent_u24lambda_u241.writeUtf8(" --data $'" + StringsKt.replace$default((String)requestBody, (String)"\n", (String)"\\n", (boolean)false, (int)4, null) + "'");
        }
        $this$toSharableContent_u24lambda_u241.writeUtf8((compressed ? " --compressed " : " ") + this.transaction.getFormattedUrl(false));
        return (Source)buffer;
    }

    private final boolean isCompressed(HttpHeader header) {
        return StringsKt.equals((String)"Accept-Encoding", (String)header.getName(), (boolean)true) && StringsKt.contains((CharSequence)"gzip", (CharSequence)header.getValue(), (boolean)true) || StringsKt.contains((CharSequence)"br", (CharSequence)header.getValue(), (boolean)true);
    }

    private final String escapeHeaderValue(String value) {
        return StringsKt.replace$default((String)value, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
    }
}

