/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Okio;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000f\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u001cR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/chuckerteam/chucker/internal/support/ReportingSink;", "Lokio/Sink;", "downstreamFile", "Ljava/io/File;", "callback", "Lcom/chuckerteam/chucker/internal/support/ReportingSink$Callback;", "writeByteLimit", "", "<init>", "(Ljava/io/File;Lcom/chuckerteam/chucker/internal/support/ReportingSink$Callback;J)V", "totalByteCount", "isFailure", "", "isClosed", "downstream", "write", "", "source", "Lokio/Buffer;", "byteCount", "flush", "close", "timeout", "Lokio/Timeout;", "callDownstreamFailure", "exception", "Ljava/io/IOException;", "safeCloseDownstream", "()Lkotlin/Unit;", "Callback", "com.github.ChuckerTeam.Chucker.library"})
public final class ReportingSink
implements Sink {
    @Nullable
    private final File downstreamFile;
    @NotNull
    private final Callback callback;
    private final long writeByteLimit;
    private long totalByteCount;
    private boolean isFailure;
    private boolean isClosed;
    @Nullable
    private Sink downstream;

    /*
     * WARNING - void declaration
     */
    public ReportingSink(@Nullable File downstreamFile, @NotNull Callback callback, long writeByteLimit) {
        Sink sink;
        ReportingSink reportingSink;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.downstreamFile = downstreamFile;
        this.callback = callback;
        this.writeByteLimit = writeByteLimit;
        ReportingSink reportingSink2 = this;
        try {
            reportingSink = reportingSink2;
            File file = this.downstreamFile;
            sink = file != null ? Okio.sink$default((File)file, (boolean)false, (int)1, null) : null;
        }
        catch (IOException iOException) {
            void e;
            reportingSink = reportingSink2;
            this.callDownstreamFailure(new IOException("Failed to use file " + this.downstreamFile + " by Chucker", (Throwable)e));
            sink = null;
        }
        reportingSink.downstream = sink;
    }

    public /* synthetic */ ReportingSink(File file, Callback callback, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = Long.MAX_VALUE;
        }
        this(file, callback, l);
    }

    public void write(@NotNull Buffer source, long byteCount) {
        long bytesToWrite;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long previousTotalByteCount = this.totalByteCount;
        this.totalByteCount += byteCount;
        if (this.isFailure || previousTotalByteCount >= this.writeByteLimit) {
            return;
        }
        long l = bytesToWrite = previousTotalByteCount + byteCount <= this.writeByteLimit ? byteCount : this.writeByteLimit - previousTotalByteCount;
        if (bytesToWrite == 0L) {
            return;
        }
        try {
            Sink sink = this.downstream;
            if (sink != null) {
                sink.write(source, bytesToWrite);
            }
        }
        catch (IOException e) {
            this.callDownstreamFailure(e);
        }
    }

    public void flush() {
        if (this.isFailure) {
            return;
        }
        try {
            Sink sink = this.downstream;
            if (sink != null) {
                sink.flush();
            }
        }
        catch (IOException e) {
            this.callDownstreamFailure(e);
        }
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.safeCloseDownstream();
        this.callback.onClosed(this.downstreamFile, this.totalByteCount);
    }

    @NotNull
    public Timeout timeout() {
        Sink sink = this.downstream;
        if (sink == null || (sink = sink.timeout()) == null) {
            sink = Timeout.NONE;
        }
        return sink;
    }

    private final void callDownstreamFailure(IOException exception) {
        if (!this.isFailure) {
            this.isFailure = true;
            this.safeCloseDownstream();
            this.callback.onFailure(this.downstreamFile, exception);
        }
    }

    private final Unit safeCloseDownstream() {
        Unit unit;
        try {
            Unit unit2;
            Sink sink = this.downstream;
            if (sink != null) {
                sink.close();
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        catch (IOException e) {
            this.callDownstreamFailure(e);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\b\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lcom/chuckerteam/chucker/internal/support/ReportingSink$Callback;", "", "onClosed", "", "file", "Ljava/io/File;", "sourceByteCount", "", "onFailure", "exception", "Ljava/io/IOException;", "com.github.ChuckerTeam.Chucker.library"})
    public static interface Callback {
        public void onClosed(@Nullable File var1, long var2);

        public void onFailure(@Nullable File var1, @NotNull IOException var2);
    }
}

