/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.repository;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionDatabaseRepository;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionRepository;
import com.chuckerteam.chucker.internal.data.room.ChuckerDatabase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/chuckerteam/chucker/internal/data/repository/RepositoryProvider;", "", "()V", "transactionRepository", "Lcom/chuckerteam/chucker/internal/data/repository/HttpTransactionRepository;", "close", "", "initialize", "applicationContext", "Landroid/content/Context;", "transaction", "com.github.ChuckerTeam.Chucker.library"})
public final class RepositoryProvider {
    @NotNull
    public static final RepositoryProvider INSTANCE = new RepositoryProvider();
    @Nullable
    private static HttpTransactionRepository transactionRepository;

    private RepositoryProvider() {
    }

    @NotNull
    public final HttpTransactionRepository transaction() {
        HttpTransactionRepository httpTransactionRepository = transactionRepository;
        if (httpTransactionRepository == null) {
            boolean bl = false;
            String string2 = "You can't access the transaction repository if you don't initialize it!";
            throw new IllegalStateException(string2.toString());
        }
        return httpTransactionRepository;
    }

    public final void initialize(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (transactionRepository == null) {
            ChuckerDatabase db = ChuckerDatabase.Companion.create(applicationContext);
            transactionRepository = new HttpTransactionDatabaseRepository(db);
        }
    }

    @VisibleForTesting
    public final void close() {
        transactionRepository = null;
    }
}

