/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.render.internal;

import android.content.Context;
import android.opengl.GLES20;
import com.jiangdg.ausbc.render.internal.AbstractFboRender;
import com.jiangdg.ausbc.render.internal.AbstractRender;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.OpenGLUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0012J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/jiangdg/ausbc/render/internal/AbstractFboRender;", "Lcom/jiangdg/ausbc/render/internal/AbstractRender;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mFBOTextures", "", "getMFBOTextures", "()[I", "mFBOTextures$delegate", "Lkotlin/Lazy;", "mFrameBuffers", "getMFrameBuffers", "mFrameBuffers$delegate", "afterDrawFBO", "", "destroyFrameBuffers", "drawFrame", "", "textureId", "getFrameBufferId", "getFrameBufferTexture", "loadFBO", "width", "height", "setSize", "Companion", "libausbc_release"})
public abstract class AbstractFboRender
extends AbstractRender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy mFrameBuffers$delegate;
    @NotNull
    private final Lazy mFBOTextures$delegate;
    @NotNull
    private static final String TAG = "AbstractFboRender";

    public AbstractFboRender(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mFrameBuffers$delegate = LazyKt.lazy((Function0)mFrameBuffers.2.INSTANCE);
        this.mFBOTextures$delegate = LazyKt.lazy((Function0)mFBOTextures.2.INSTANCE);
    }

    private final int[] getMFrameBuffers() {
        Lazy lazy = this.mFrameBuffers$delegate;
        boolean bl = false;
        return (int[])lazy.getValue();
    }

    private final int[] getMFBOTextures() {
        Lazy lazy = this.mFBOTextures$delegate;
        boolean bl = false;
        return (int[])lazy.getValue();
    }

    public final int getFrameBufferId() {
        return this.getMFrameBuffers()[0];
    }

    public final int getFrameBufferTexture() {
        return this.getMFBOTextures()[0];
    }

    @Override
    public int drawFrame(int textureId) {
        GLES20.glBindFramebuffer((int)36160, (int)this.getMFrameBuffers()[0]);
        super.drawFrame(textureId);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        this.afterDrawFBO();
        return this.getMFBOTextures()[0];
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.loadFBO(width, height);
    }

    protected void afterDrawFBO() {
    }

    private final void loadFBO(int width, int height) {
        this.destroyFrameBuffers();
        GLES20.glGenFramebuffers((int)this.getMFrameBuffers().length, (int[])this.getMFrameBuffers(), (int)0);
        this.createTexture(this.getMFBOTextures());
        GLES20.glBindTexture((int)3553, (int)this.getMFBOTextures()[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GLES20.glBindFramebuffer((int)36160, (int)this.getMFrameBuffers()[0]);
        OpenGLUtils.INSTANCE.checkGlError("glBindFramebuffer");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.getMFBOTextures()[0], (int)0);
        OpenGLUtils.INSTANCE.checkGlError("glFramebufferTexture2D");
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        Logger.INSTANCE.i(TAG, "load fbo, textures: " + this.getMFBOTextures() + ", buffers: " + this.getMFrameBuffers());
    }

    private final void destroyFrameBuffers() {
        GLES20.glDeleteTextures((int)1, (int[])this.getMFBOTextures(), (int)0);
        GLES20.glDeleteFramebuffers((int)1, (int[])this.getMFrameBuffers(), (int)0);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jiangdg/ausbc/render/internal/AbstractFboRender$Companion;", "", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

