/*
 * Decompiled with CFR 0.152.
 */
package com.github.chenglei1986.statusbar;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.chenglei1986.statusbar.BrandUtil;
import com.github.chenglei1986.statusbar.ColorUtil;
import com.github.chenglei1986.statusbar.ScrimUtil;
import com.github.chenglei1986.statusbar.StatusBarUtil;

public class StatusBarColorManager {
    private StatusBarColorManagerImpl mStatusBarColorManagerImpl;

    public StatusBarColorManager(@NonNull Activity activity) {
        this.mStatusBarColorManagerImpl = Build.VERSION.SDK_INT >= 23 ? new StatusBarColorManagerImplApi23(activity) : (Build.VERSION.SDK_INT >= 21 ? new StatusBarColorManagerImplApi21(activity) : (Build.VERSION.SDK_INT >= 19 ? new StatusBarColorManagerImplApi19(activity) : new StatusBarColorManagerBase()));
    }

    public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
        this.mStatusBarColorManagerImpl.setStatusBarColor(color, layoutFullscreen, withActionBar);
    }

    public void setStatusBarColorRes(@ColorRes int colorRes, boolean layoutFullscreen, boolean withActionBar) {
        this.mStatusBarColorManagerImpl.setStatusBarColorRes(colorRes, layoutFullscreen, withActionBar);
    }

    public void setStatusBarBackground(@DrawableRes int drawableRes, boolean layoutFullscreen, boolean withActionBar) {
        this.mStatusBarColorManagerImpl.setStatusBarBackground(drawableRes, layoutFullscreen, withActionBar);
    }

    public void setStatusBarBackground(Drawable drawable, boolean layoutFullscreen, boolean withActionBar) {
        this.mStatusBarColorManagerImpl.setStatusBarBackground(drawable, layoutFullscreen, withActionBar);
    }

    public void setLightStatusBar(boolean light) {
        this.mStatusBarColorManagerImpl.setLightStatusBar(light);
    }

    @RequiresApi(api=23)
    private static class StatusBarColorManagerImplApi23
    extends StatusBarColorManagerImplApi21 {
        public StatusBarColorManagerImplApi23(@NonNull Activity activity) {
            super(activity);
        }

        @Override
        public void setLightStatusBar(boolean light) {
            if (BrandUtil.checkBrand(BrandUtil.BRAND.XIAOMI)) {
                StatusBarUtil.setMiuiStatusBarIconDarkMode(this.mActivity, light);
            } else if (BrandUtil.checkBrand(BrandUtil.BRAND.MEIZU)) {
                StatusBarUtil.setFlymeStatusBarIconDarkMode(this.mActivity, light);
            }
            if (light) {
                this.mDecorView.setSystemUiVisibility(this.mDecorView.getSystemUiVisibility() | 0x2000);
            } else {
                this.mDecorView.setSystemUiVisibility(this.mDecorView.getSystemUiVisibility() & 0xFFFFDFFF);
            }
        }
    }

    @RequiresApi(api=21)
    private static class StatusBarColorManagerImplApi21
    extends StatusBarColorManagerImplApi19 {
        public StatusBarColorManagerImplApi21(@NonNull Activity activity) {
            super(activity);
        }

        @Override
        public void setLightStatusBar(boolean light) {
            if (BrandUtil.checkBrand(BrandUtil.BRAND.XIAOMI)) {
                StatusBarUtil.setMiuiStatusBarIconDarkMode(this.mActivity, light);
            } else if (BrandUtil.checkBrand(BrandUtil.BRAND.MEIZU)) {
                StatusBarUtil.setFlymeStatusBarIconDarkMode(this.mActivity, light);
            } else {
                this.mStatusBarBackground.removeAllViews();
                if (light) {
                    View scrimView = new View((Context)this.mActivity);
                    scrimView.setBackground(ScrimUtil.makeCubicGradientScrimDrawable(-16777216, 8, 48));
                    this.mStatusBarBackground.addView(scrimView);
                }
            }
        }
    }

    @RequiresApi(api=19)
    private static class StatusBarColorManagerImplApi19
    extends StatusBarColorManagerBase {
        protected Activity mActivity;
        protected ViewGroup mDecorView;
        protected FrameLayout mStatusBarBackground;
        protected int mStatusBarHeight;
        protected int mActionBarHeight;
        protected ViewGroup mContentView;

        public StatusBarColorManagerImplApi19(@NonNull Activity activity) {
            this.mActivity = activity;
            StatusBarUtil.setTranslucentStatus(this.mActivity);
            this.mDecorView = (ViewGroup)activity.getWindow().getDecorView();
            this.mContentView = (ViewGroup)((ViewGroup)this.mDecorView.findViewById(0x1020002)).getChildAt(0);
            if (null == this.mContentView) {
                throw new IllegalStateException("****** You must initialize StatusBarColorManager after setContentView() ******");
            }
            this.mStatusBarHeight = StatusBarUtil.getStatusHeight(activity);
            this.mActionBarHeight = StatusBarUtil.getActionBarHeight((Context)activity);
            if (null == this.mStatusBarBackground) {
                this.mStatusBarBackground = new FrameLayout((Context)activity);
                this.mDecorView.addView((View)this.mStatusBarBackground, -1, this.mStatusBarHeight);
            }
        }

        protected void setColor(@ColorInt int color, boolean layoutFullscreen) {
            boolean light = ColorUtil.isLightColor(color);
            this.setLightStatusBar(light);
            this.mStatusBarBackground.setBackgroundColor(layoutFullscreen ? 0 : color);
        }

        protected void setColorRes(@ColorRes int colorRes, boolean layoutFullscreen) {
            int color = Build.VERSION.SDK_INT >= 23 ? this.mActivity.getColor(colorRes) : this.mActivity.getResources().getColor(colorRes);
            boolean light = ColorUtil.isLightColor(color);
            this.setLightStatusBar(light);
            this.mStatusBarBackground.setBackgroundColor(layoutFullscreen ? 0 : color);
        }

        protected void setDrawable(Drawable drawable) {
            if (Build.VERSION.SDK_INT >= 15) {
                this.mStatusBarBackground.setBackground(drawable);
            } else {
                this.mStatusBarBackground.setBackgroundDrawable(drawable);
            }
        }

        protected void setDrawableRes(@DrawableRes int drawableRes) {
            this.mStatusBarBackground.setBackgroundResource(drawableRes);
        }

        protected void setContentPadding(boolean layoutFullscreen, boolean withActionBar) {
            int contentViewPaddingTop = (layoutFullscreen ? 0 : this.mStatusBarHeight) + (withActionBar ? this.mActionBarHeight : 0);
            this.mContentView.setPadding(this.mContentView.getPaddingLeft(), contentViewPaddingTop, this.mContentView.getPaddingRight(), this.mContentView.getPaddingBottom());
        }

        @Override
        public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
            this.setColor(color, layoutFullscreen);
            this.setContentPadding(layoutFullscreen, withActionBar);
        }

        @Override
        public void setStatusBarColorRes(int colorRes, boolean layoutFullscreen, boolean withActionBar) {
            this.setColorRes(colorRes, layoutFullscreen);
            this.setContentPadding(layoutFullscreen, withActionBar);
        }

        @Override
        public void setStatusBarBackground(int drawableRes, boolean layoutFullscreen, boolean withActionBar) {
            this.setDrawableRes(drawableRes);
            this.setContentPadding(layoutFullscreen, withActionBar);
        }

        @Override
        public void setStatusBarBackground(Drawable drawable, boolean layoutFullscreen, boolean withActionBar) {
            this.setDrawable(drawable);
            this.setContentPadding(layoutFullscreen, withActionBar);
        }

        @Override
        public void setLightStatusBar(boolean light) {
            if (BrandUtil.checkBrand(BrandUtil.BRAND.XIAOMI)) {
                StatusBarUtil.setMiuiStatusBarIconDarkMode(this.mActivity, light);
            } else if (BrandUtil.checkBrand(BrandUtil.BRAND.MEIZU)) {
                StatusBarUtil.setFlymeStatusBarIconDarkMode(this.mActivity, light);
            }
        }
    }

    private static class StatusBarColorManagerBase
    implements StatusBarColorManagerImpl {
        private StatusBarColorManagerBase() {
        }

        @Override
        public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
        }

        @Override
        public void setStatusBarColorRes(int colorRes, boolean layoutFullscreen, boolean withActionBar) {
        }

        @Override
        public void setStatusBarBackground(int drawableRes, boolean layoutFullscreen, boolean withActionBar) {
        }

        @Override
        public void setStatusBarBackground(Drawable drawable, boolean layoutFullscreen, boolean withActionBar) {
        }

        @Override
        public void setLightStatusBar(boolean light) {
        }
    }

    private static interface StatusBarColorManagerImpl {
        public void setStatusBarColor(@ColorInt int var1, boolean var2, boolean var3);

        public void setStatusBarColorRes(@ColorRes int var1, boolean var2, boolean var3);

        public void setStatusBarBackground(@DrawableRes int var1, boolean var2, boolean var3);

        public void setStatusBarBackground(Drawable var1, boolean var2, boolean var3);

        public void setLightStatusBar(boolean var1);
    }
}

