/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.checkmarx.sdk.config.CxGoProperties;
import com.checkmarx.sdk.config.CxPropertiesBase;
import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.ScanResults;
import com.checkmarx.sdk.dto.ast.SCAResults;
import com.checkmarx.sdk.dto.ast.Summary;
import com.checkmarx.sdk.dto.cx.CxProject;
import com.checkmarx.sdk.dto.cx.CxScanParams;
import com.checkmarx.sdk.dto.cx.CxScanSettings;
import com.checkmarx.sdk.dto.cx.CxScanSummary;
import com.checkmarx.sdk.dto.cxgo.CreateScan;
import com.checkmarx.sdk.dto.cxgo.CreateScanResponse;
import com.checkmarx.sdk.dto.cxgo.Fields;
import com.checkmarx.sdk.dto.cxgo.OdApplicationCreate;
import com.checkmarx.sdk.dto.cxgo.OdNavigationTree;
import com.checkmarx.sdk.dto.cxgo.OdProjectCreate;
import com.checkmarx.sdk.dto.cxgo.OdProjectList;
import com.checkmarx.sdk.dto.cxgo.OdProjectListDataItem;
import com.checkmarx.sdk.dto.cxgo.OdScanFileResult;
import com.checkmarx.sdk.dto.cxgo.OdScanList;
import com.checkmarx.sdk.dto.cxgo.OdScanListDataItem;
import com.checkmarx.sdk.dto.cxgo.OdScanResultItem;
import com.checkmarx.sdk.dto.cxgo.OdScanResults;
import com.checkmarx.sdk.dto.cxgo.ResultNode;
import com.checkmarx.sdk.dto.cxgo.SASTScanResult;
import com.checkmarx.sdk.dto.cxgo.SCAScanResult;
import com.checkmarx.sdk.dto.cxgo.Scan;
import com.checkmarx.sdk.dto.cxgo.ScanStatus;
import com.checkmarx.sdk.dto.cxgo.Storage;
import com.checkmarx.sdk.dto.filtering.FilterConfiguration;
import com.checkmarx.sdk.dto.filtering.FilterInput;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.exception.CheckmarxRuntimeException;
import com.checkmarx.sdk.service.CxGoAuthService;
import com.checkmarx.sdk.service.CxRepoFileService;
import com.checkmarx.sdk.service.FilterInputFactory;
import com.checkmarx.sdk.service.FilterValidator;
import com.cx.restclient.ScannerClient;
import com.cx.restclient.ast.dto.sca.report.Finding;
import com.cx.restclient.ast.dto.sca.report.Package;
import com.cx.restclient.dto.scansummary.Severity;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class CxGoClientImpl
implements ScannerClient {
    private static final Logger log = LoggerFactory.getLogger(CxGoClientImpl.class);
    private static final String UNKNOWN = "-1";
    private static final Integer UNKNOWN_INT = -1;
    private static final String CREATE_SCAN = "/v1/scans";
    private static final String SCAN_STATUS = "/v1/scans/{scan_id}/status";
    private static final String SCAN = "/v1/scans/{scan_id}";
    private static final String SCANS = "/v1/scans";
    private static final String SCAN_RESULTS_ENCODED = "/results/results?criteria=%7B%22criteria%22%3A%5B%7B%22key%22%3A%22projectId%22%2C%22value%22%3A%22{project_id}%22%7D%2C%7B%22key%22%3A%22scanId%22%2C%22value%22%3A%22{scan_id}%22%7D%5D%2C%22pagination%22%3A%7B%22currentPage%22%3A{current_page%2C%22pageSize%22%3A{page_size}%7D%7D";
    private static final String SCAN_RESULTS = "/v1/scans/{scan_id}/results";
    private static final String SCAN_FILE = "/projects/projects/{project_id}/scans/{scan_id}/files?filePath={file_path};";
    private static final String CREATE_APPLICATION = "/applications/applications";
    private static final String CREATE_PROJECT = "/projects/projects";
    private static final String GET_PROJECTS = "/projects/projects?criteria=%7B%22criteria%22%3A%5B%7B%22key%22%3A%22applicationId%22%2C%22value%22%3A%22{app_id}%22%7D%5D%2C%22pagination%22%3A%7B%22currentPage%22%3A{cur_page}%2C%22pageSize%22%3A{page_size}%7D%2C%22sorting%22%3A%5B%5D%7D";
    private static final String GET_SCAN_STATUS = "/scans/scans?criteria=%7B%22filters%22%3A%5B%5D%2C%22criteria%22%3A%5B%7B%22key%22%3A%22projectId%22%2C%22value%22%3A%22{project_id}%22%7D%5D%2C%22sorting%22%3A%5B%5D%2C%22pagination%22%3A%7B%22currentPage%22%3A{cur_page}%2C%22pageSize%22%3A{page_size}%7D%7D";
    private static final String DEEP_LINK = "/scan/business-unit/%s/application/%s/project/%s/scans/%s";
    private static final String SCA_DEEP_LINK = "/scan/business-unit/%s/application/%s/project/%s";
    private static final String ADDITIONAL_DETAILS_KEY = "results";
    private static final String CXGO_SCAN_STATUS_DONE = "Done";
    private static final String CXGO_SCAN_STATUS_PARTIAL = "Partial";
    private static final String CXGO_SCAN_STATUS_COMPLETED = "Completed";
    private static Map<String, CxScanParams> scanIdMap = new HashMap<String, CxScanParams>();
    private static final List<CxScanParams> scanProbeMap = new LinkedList<CxScanParams>();
    private final CxGoProperties cxGoProperties;
    private final CxGoAuthService authClient;
    private final RestTemplate restTemplate;
    private final Map<String, Object> codeCache = new HashMap<String, Object>();
    private CxRepoFileService cxRepoFileService;
    private final FilterInputFactory filterInputFactory;
    private final FilterValidator filterValidator;

    public CxGoClientImpl(CxGoProperties cxProperties, CxGoAuthService authClient, @Qualifier(value="cxRestTemplate") RestTemplate restTemplate, FilterInputFactory filterInputFactory, FilterValidator filterValidator) {
        this.cxGoProperties = cxProperties;
        this.authClient = authClient;
        this.restTemplate = restTemplate;
        this.filterInputFactory = filterInputFactory;
        this.filterValidator = filterValidator;
    }

    @Override
    public Integer getScanIdOfExistingScanIfExists(Integer projectId) {
        return UNKNOWN_INT;
    }

    @Override
    public void cancelScan(Integer scanId) throws CheckmarxException {
    }

    private String createApplication(String appName, String appDesc, String baBuId) {
        log.info("Creating new CxGo application {}.", (Object)appName);
        HttpEntity httpEntity = new HttpEntity((Object)this.getJSONCreateAppReq(appName, appDesc, baBuId), (MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity createResp = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(CREATE_APPLICATION), HttpMethod.PUT, httpEntity, OdApplicationCreate.class, new Object[0]);
        OdApplicationCreate appCreate = (OdApplicationCreate)createResp.getBody();
        assert (appCreate != null);
        return appCreate.getData().getBaId();
    }

    private String getJSONCreateAppReq(String appName, String appDesc, String baBuId) {
        JSONObject requestBody = new JSONObject();
        JSONObject createBody = new JSONObject();
        try {
            createBody.put("baName", (Object)appName);
            createBody.put("description", (Object)appDesc);
            createBody.put("criticality", 5);
            createBody.put("baBuId", (Object)baBuId);
            createBody.put("licenseType", (Object)"standard");
            requestBody.put("businessApplication", (Object)createBody);
        }
        catch (JSONException e) {
            log.error("Error generating JSON App create Request object - JSON object will be empty");
        }
        return requestBody.toString();
    }

    public String createCxGoProject(String appId, String projectName, String presets) {
        log.info("Creating new CxGo project.");
        HttpEntity httpEntity = new HttpEntity((Object)this.getJSONCreateProjectReq(appId, projectName, presets), (MultiValueMap)this.authClient.createAuthHeaders());
        ResponseEntity createResp = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(CREATE_PROJECT), HttpMethod.PUT, httpEntity, OdProjectCreate.class, new Object[0]);
        OdProjectCreate appCreate = (OdProjectCreate)createResp.getBody();
        return appCreate.getData().getId();
    }

    private String getJSONCreateProjectReq(String appId, String projectName, String preset) {
        JSONObject requestBody = new JSONObject();
        JSONObject createBody = new JSONObject();
        try {
            createBody.put("businessApplicationId", (Object)appId);
            createBody.put("name", (Object)projectName);
            createBody.put("description", (Object)"");
            if (StringUtils.isEmpty((Object)preset)) {
                preset = this.cxGoProperties.getScanPreset();
            }
            String[] presets = preset.split(",");
            createBody.put("typeIds", (Object)presets);
            createBody.put("criticality", 5);
            requestBody.put("project", (Object)createBody);
        }
        catch (JSONException e) {
            log.error("Error generating JSON Project create Request object - JSON object will be empty");
        }
        return requestBody.toString();
    }

    @Override
    public Integer createScan(CxScanParams params, String comment) throws CheckmarxException {
        try {
            String appID = params.getTeamId();
            Integer projectID = this.getProjectId(appID, params.getProjectName());
            if (projectID.equals(UNKNOWN_INT)) {
                projectID = Integer.parseInt(this.createCxGoProject(appID, params.getProjectName(), params.getScanPreset()));
            }
            params.setProjectId(projectID);
            CreateScan scan = CreateScan.builder().projectId(params.getProjectId()).engineTypes(this.cxGoProperties.getEngineTypes()).build();
            log.info("Sending scan to CxGo for projectID {}.", (Object)params.getProjectId());
            HttpHeaders headers = this.authClient.createAuthHeaders(params.getClientSecret());
            HttpEntity httpEntity = new HttpEntity((Object)scan, (MultiValueMap)headers);
            ResponseEntity createResp = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat("/v1/scans"), HttpMethod.POST, httpEntity, CreateScanResponse.class, new Object[0]);
            CreateScanResponse scanCreate = (CreateScanResponse)createResp.getBody();
            assert (scanCreate != null);
            Integer scanId = scanCreate.getScan().getId();
            log.info("CxGo started scan with scanId {}.", (Object)scanId);
            log.info("CxGo Uploading Scan file {}.", (Object)scanId);
            File archive = params.getSourceType() == CxScanParams.Type.FILE ? new File(params.getFilePath()) : new File(this.cxRepoFileService.prepareRepoFile(params));
            this.uploadScanFile(scanCreate.getStorage(), archive);
            FileSystemUtils.deleteRecursively((File)archive);
            return scanId;
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            log.error("Http Exception: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
            throw new CheckmarxException("Http error occurred");
        }
        catch (NullPointerException e) {
            log.error("Null Exception: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
            throw new CheckmarxException("NullPointerException occurred");
        }
    }

    private void uploadScanFile(Storage scanStorage, File file) throws CheckmarxException {
        try {
            Fields scanFields = scanStorage.getFields();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"key", (Object)scanFields.getKey());
            body.add((Object)"bucket", (Object)scanFields.getBucket());
            body.add((Object)"X-Amz-Algorithm", (Object)scanFields.getXAmzAlgorithm());
            body.add((Object)"X-Amz-Credential", (Object)scanFields.getXAmzCredential());
            body.add((Object)"X-Amz-Date", (Object)scanFields.getXAmzDate());
            body.add((Object)"X-Amz-Security-Token", (Object)scanFields.getXAmzSecurityToken());
            body.add((Object)"Policy", (Object)scanFields.getPolicy());
            body.add((Object)"X-Amz-Signature", (Object)scanFields.getXAmzSignature());
            FileSystemResource fsr = new FileSystemResource(file);
            body.add((Object)"file", (Object)fsr);
            HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            this.restTemplate.exchange(scanStorage.getUrl(), HttpMethod.POST, requestEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            log.error("CxGo error uploading file.", (Throwable)e);
            throw new CheckmarxException("Error Uploading Source to ".concat(scanStorage.getUrl()));
        }
    }

    @Override
    public String getTeamId(String teamPath) throws CheckmarxException {
        return this.extractTeamId(teamPath, null);
    }

    @Override
    public String getTeamIdByClientSecret(String teamPath, String clientSecret) throws CheckmarxException {
        return this.extractTeamId(teamPath, clientSecret);
    }

    private String extractTeamId(String teamPath, String clientSecret) throws CheckmarxException {
        String[] buTokens = teamPath.split(Pattern.quote("\\"));
        OdNavigationTree navTree = this.getNavigationTree(clientSecret);
        LinkedHashMap navTreeData = (LinkedHashMap)navTree.getAdditionalProperties().get("data");
        ArrayList tree = (ArrayList)navTreeData.get("tree");
        int i = 1;
        String token = buTokens[i++];
        for (LinkedHashMap item : tree) {
            Object o = item.get("id");
            Integer id = (Integer)o;
            o = item.get("title");
            String title = (String)o;
            title = title.trim();
            o = item.get("children");
            ArrayList children = (ArrayList)o;
            if (!title.equals(token)) continue;
            if (i == buTokens.length) {
                CxScanParams csp = this.getScanProbeByTeam(id.toString());
                csp.setTeamName(teamPath);
                return id.toString();
            }
            return this.searchTreeChildren(teamPath, buTokens, i, children);
        }
        return UNKNOWN;
    }

    private String searchTreeChildren(String teamPath, String[] buTokens, int i, ArrayList<Object> children) {
        String token = buTokens[i++];
        for (Object item : children) {
            LinkedHashMap node = (LinkedHashMap)item;
            Object o = node.get("id");
            Integer id = (Integer)o;
            o = node.get("title");
            String title = (String)o;
            title = title.trim();
            o = node.get("children");
            ArrayList nodeChildren = (ArrayList)o;
            if (!title.equals(token)) continue;
            if (i == buTokens.length) {
                CxScanParams csp = this.getScanProbeByTeam(id.toString());
                csp.setTeamName(teamPath);
                return id.toString();
            }
            return this.searchTreeChildren(teamPath, buTokens, i, nodeChildren);
        }
        return UNKNOWN;
    }

    private OdNavigationTree getNavigationTree(String clientSecret) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders(clientSecret));
        try {
            log.debug("Retrieving OD Navigation Tree");
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat("/navigation-tree/navigation-tree"), HttpMethod.GET, httpEntity, OdNavigationTree.class, new Object[0]);
            return (OdNavigationTree)response.getBody();
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving the navigation tree.");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error retrieving Business Units.");
        }
    }

    @Override
    public String createTeam(String parentID, String teamName) throws CheckmarxException {
        return this.createApplication(teamName, "Generated by CxFlow", parentID);
    }

    @Override
    public ScanResults getReportContentByScanId(Integer scanId, FilterConfiguration filter) throws CheckmarxException {
        List rawScanResults;
        ScanResults.ScanResultsBuilder results = ScanResults.builder();
        Scan scan = this.getScanDetails(scanId);
        Integer projectId = scan.getProjectId();
        Integer buId = scan.getBusinessUnitId();
        Integer appId = scan.getApplicationId();
        com.checkmarx.sdk.dto.cxgo.ScanResults resultFromAllEngines = this.getScanResults(scanId);
        ArrayList<ScanResults.XIssue> xIssues = new ArrayList<ScanResults.XIssue>();
        List mainResultInfos = Optional.ofNullable(resultFromAllEngines).map(com.checkmarx.sdk.dto.cxgo.ScanResults::getSast).orElse(null);
        if (mainResultInfos != null) {
            Map<String, OdScanResultItem> additionalResultInfos = this.getScanResultsPage(projectId, scanId);
            HashMap issuesBySeverity = new HashMap();
            log.debug("SAST finding count before filtering: {}", (Object)mainResultInfos.size());
            log.info("Processing SAST results");
            mainResultInfos.stream().filter(this.applySastFilter(additionalResultInfos, filter)).forEach(mainResultInfo -> this.handleSastIssue((List<ScanResults.XIssue>)xIssues, (SASTScanResult)mainResultInfo, additionalResultInfos, projectId, scanId, issuesBySeverity));
            CxScanSummary scanSummary = CxGoClientImpl.getCxScanSummary(scan);
            HashMap<String, Object> flowSummary = new HashMap<String, Object>();
            flowSummary.put("flow-summary", issuesBySeverity);
            flowSummary.put("scanId", scanId);
            results.additionalDetails(flowSummary);
            results.scanSummary(scanSummary);
        }
        if ((rawScanResults = (List)Optional.ofNullable(resultFromAllEngines).map(com.checkmarx.sdk.dto.cxgo.ScanResults::getSca).orElse(null)) != null) {
            CxGoClientImpl.logRawScaScanResults(rawScanResults);
            ArrayList<Finding> findings = new ArrayList<Finding>();
            ArrayList<Package> packages = new ArrayList<Package>();
            log.info("Processing SCA results");
            rawScanResults.stream().filter(rawScanResult -> !rawScanResult.isIgnored()).filter(this.applyScaFilter(filter)).forEach(rawScanResult -> this.handleScaIssue((List<ScanResults.XIssue>)xIssues, (List<Finding>)findings, (List<Package>)packages, (SCAScanResult)rawScanResult));
            CxGoClientImpl.logFindings(findings);
            CxGoClientImpl.logPackages(packages);
            SCAResults scaResults = new SCAResults();
            scaResults.setFindings(findings);
            scaResults.setPackages(packages);
            if (!rawScanResults.isEmpty()) {
                scaResults.setScanId(((SCAScanResult)rawScanResults.get(0)).getScanId().toString());
            }
            Summary summary = CxGoClientImpl.getScaScanSummary(scan);
            scaResults.setSummary(summary);
            String urlTemplate = this.cxGoProperties.getPortalUrl().concat(SCA_DEEP_LINK);
            String scaDeepLink = String.format(urlTemplate, buId, appId, projectId, scanId);
            scaResults.setWebReportLink(scaDeepLink);
            results.scaResults(scaResults);
        }
        results.xIssues(xIssues);
        results.projectId(projectId.toString());
        String urlTemplate = this.cxGoProperties.getPortalUrl().concat(DEEP_LINK);
        String deepLink = String.format(urlTemplate, buId, appId, projectId, scanId);
        results.link(deepLink);
        return results.build();
    }

    private static void logRawScaScanResults(List<SCAScanResult> rawScanResults) {
        if (log.isDebugEnabled()) {
            log.debug("Raw CxGo-SCA findings, before filtering:");
            rawScanResults.forEach(scaScanResult -> log.debug("Id: {}, package id: {}", (Object)scaScanResult.getId(), (Object)scaScanResult.getPackageId()));
        }
    }

    private static void logPackages(List<Package> packages) {
        if (log.isDebugEnabled()) {
            log.debug("CxGo-SCA packages:");
            packages.forEach(aPackage -> log.debug("Id: {}, version: {}", (Object)aPackage.getId(), (Object)aPackage.getVersion()));
        }
    }

    private static void logFindings(List<Finding> findings) {
        if (log.isDebugEnabled()) {
            log.debug("CxGo-SCA findings after filtering:");
            findings.forEach(finding -> log.debug("Id: {}, package id: {}", (Object)finding.getId(), (Object)finding.getPackageId()));
        }
    }

    private static Summary getScaScanSummary(Scan scanDetails) {
        Map scaScanDetails = (Map)scanDetails.getEngines().get("sca");
        Summary summary = new Summary();
        EnumMap<Filter.Severity, Integer> severityMap = new EnumMap<Filter.Severity, Integer>(Filter.Severity.class);
        if (scaScanDetails != null) {
            int high = (Integer)scaScanDetails.get("high_severities_count");
            int med = (Integer)scaScanDetails.get("medium_severities_count");
            int low = (Integer)scaScanDetails.get("low_severities_count");
            severityMap.put(Filter.Severity.HIGH, high);
            severityMap.put(Filter.Severity.MEDIUM, med);
            severityMap.put(Filter.Severity.LOW, low);
            severityMap.put(Filter.Severity.INFO, 0);
        }
        summary.setFindingCounts(severityMap);
        return summary;
    }

    private static CxScanSummary getCxScanSummary(Scan scanDetails) {
        CxScanSummary scanSummary = new CxScanSummary();
        Map sastScanDetails = (Map)scanDetails.getEngines().get("sast");
        if (sastScanDetails != null) {
            int high = (Integer)sastScanDetails.get("high_severities_count");
            int med = (Integer)sastScanDetails.get("medium_severities_count");
            int low = (Integer)sastScanDetails.get("low_severities_count");
            scanSummary.setHighSeverity(high);
            scanSummary.setMediumSeverity(med);
            scanSummary.setLowSeverity(low);
            scanSummary.setInfoSeverity(0);
        }
        return scanSummary;
    }

    private Predicate<SASTScanResult> applySastFilter(Map<String, OdScanResultItem> additionalResultInfos, FilterConfiguration filter) {
        return mainResultInfo -> {
            String resultId = mainResultInfo.getId().toString();
            OdScanResultItem additionalResultInfo = (OdScanResultItem)additionalResultInfos.get(resultId);
            FilterInput filterInput = this.filterInputFactory.createFilterInputForCxGoSast((SASTScanResult)mainResultInfo, additionalResultInfo);
            return this.filterValidator.passesFilter(filterInput, filter.getSastFilters());
        };
    }

    private Predicate<? super SCAScanResult> applyScaFilter(FilterConfiguration filterConfig) {
        return rawScanResult -> {
            FilterInput filterInput = this.filterInputFactory.createFilterInputForCxGoSca((SCAScanResult)rawScanResult);
            return this.filterValidator.passesFilter(filterInput, filterConfig.getScaFilters());
        };
    }

    private void handleSastIssue(List<ScanResults.XIssue> xIssues, SASTScanResult sastResult, Map<String, OdScanResultItem> scanResultItems, int projectId, int scanId, Map<String, Integer> issuesBySeverity) {
        List<HashMap<String, Object>> resultList;
        boolean newIssue = true;
        OdScanResultItem x = scanResultItems.get(sastResult.getId().toString());
        sastResult.setVulnerabilityType(x.getTitle());
        ScanResults.XIssue xIssue = ScanResults.XIssue.builder().vulnerability(sastResult.getVulnerabilityType()).file(sastResult.getSourceNode().getFilePath()).description(sastResult.getDescription()).cwe(sastResult.getCwe()).language(sastResult.getLanguageName()).severity(sastResult.getSeverity().getSeverity()).similarityId(sastResult.getSimilarityId().toString()).build();
        if (xIssues.contains(xIssue)) {
            ScanResults.XIssue tmp = xIssues.get(xIssues.indexOf(xIssue));
            if (tmp != null) {
                newIssue = false;
                xIssue = tmp;
            }
        } else {
            Integer count = issuesBySeverity.get(sastResult.getSeverity().getSeverity());
            if (count == null) {
                issuesBySeverity.put(sastResult.getSeverity().getSeverity(), 1);
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                issuesBySeverity.put(sastResult.getSeverity().getSeverity(), count);
            }
            xIssue.setDetails(new HashMap<Integer, ScanResults.IssueDetails>());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("source", this.getNodeData(sastResult.getSourceNode()));
        result.put("sink", this.getNodeData(sastResult.getSinkNode()));
        result.put("state", sastResult.getState());
        if (xIssue.getAdditionalDetails() == null || xIssue.getAdditionalDetails().get(ADDITIONAL_DETAILS_KEY) == null) {
            resultList = new ArrayList<HashMap<String, Object>>();
            if (xIssue.getAdditionalDetails() == null) {
                xIssue.setAdditionalDetails(new HashMap<String, Object>());
            }
        } else {
            resultList = (List)xIssue.getAdditionalDetails().get(ADDITIONAL_DETAILS_KEY);
        }
        resultList.add(result);
        int loc = sastResult.getSourceNode().getLine();
        String snippet = this.extractCodeSnippet(projectId, scanId, loc, sastResult.getSourceNode().getFilePath());
        ScanResults.IssueDetails details = new ScanResults.IssueDetails();
        details.setCodeSnippet(snippet);
        if (sastResult.getState().equals(SASTScanResult.State.NOT_EXPLOITABLE.getValue())) {
            details.setFalsePositive(true);
        }
        xIssue.getDetails().put(loc, details);
        xIssue.getAdditionalDetails().put(ADDITIONAL_DETAILS_KEY, resultList);
        if (newIssue) {
            xIssues.add(xIssue);
        }
    }

    private void handleScaIssue(List<ScanResults.XIssue> xIssues, List<Finding> findings, List<Package> packages, SCAScanResult scaResult) {
        Finding finding = CxGoClientImpl.toFinding(scaResult);
        findings.add(finding);
        Package pkg = CxGoClientImpl.toPackage(scaResult);
        packages.add(pkg);
        ScanResults.ScaDetails scaDetail = ScanResults.ScaDetails.builder().finding(finding).vulnerabilityLink("N/A").vulnerabilityPackage(pkg).build();
        List<ScanResults.ScaDetails> scaDetails = Collections.singletonList(scaDetail);
        xIssues.add(ScanResults.XIssue.builder().similarityId(finding.getSimilarityId()).severity(finding.getSeverity().toString()).description(finding.getDescription()).scaDetails(scaDetails).build());
    }

    private static Finding toFinding(SCAScanResult scaResult) {
        Finding finding = new Finding();
        finding.setCveName(scaResult.getCveName());
        finding.setDescription(scaResult.getDescription());
        finding.setId(scaResult.getId());
        finding.setIgnored(scaResult.isIgnored());
        finding.setPackageId(scaResult.getPackageId());
        finding.setFixResolutionText(scaResult.getFixResolutionText());
        finding.setPublishDate(scaResult.getPublishedAt());
        finding.setScore(scaResult.getScore().doubleValue());
        finding.setSimilarityId(scaResult.getSimilarityId());
        finding.setSeverity(Severity.valueOf((String)scaResult.getSeverity().getSeverity().toUpperCase()));
        finding.setSeverity(Severity.valueOf((String)scaResult.getSeverity().getSeverity().toUpperCase()));
        return finding;
    }

    private static Package toPackage(SCAScanResult scaResult) {
        Package pkg = new Package();
        pkg.setId(scaResult.getPackageId());
        pkg.setVersion(scaResult.getFixResolutionText());
        pkg.setName(scaResult.getPackageId());
        return pkg;
    }

    private Map<String, String> getNodeData(ResultNode node) {
        HashMap<String, String> nodeData = new HashMap<String, String>();
        nodeData.put("file", node.getFileName());
        nodeData.put("line", node.getLine().toString());
        nodeData.put("column", node.getColumn().toString());
        nodeData.put("object", node.getName());
        return nodeData;
    }

    private void updateIssueSummary(CxScanSummary scanSummary, OdScanResultItem vulnerability) {
        if (scanSummary.getLowSeverity() == null) {
            scanSummary.setLowSeverity(0);
        }
        if (scanSummary.getMediumSeverity() == null) {
            scanSummary.setMediumSeverity(0);
        }
        if (scanSummary.getHighSeverity() == null) {
            scanSummary.setHighSeverity(0);
        }
        if (vulnerability.getSeverity().equals("low")) {
            scanSummary.setLowSeverity(scanSummary.getLowSeverity() + 1);
        }
        if (vulnerability.getSeverity().equals("medium")) {
            scanSummary.setMediumSeverity(scanSummary.getMediumSeverity() + 1);
        }
        if (vulnerability.getSeverity().equals("high")) {
            scanSummary.setHighSeverity(scanSummary.getHighSeverity() + 1);
        }
    }

    private String extractCodeSnippet(Integer projectId, Integer scanId, Integer lineNumber, String filePath) {
        String sourceCode;
        if (this.codeCache.containsKey(filePath)) {
            sourceCode = (String)this.codeCache.get(filePath);
        } else {
            HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.authClient.createAuthHeaders());
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(SCAN_FILE), HttpMethod.GET, httpEntity, OdScanFileResult.class, new Object[]{projectId, scanId, filePath});
            OdScanFileResult sfr = (OdScanFileResult)response.getBody();
            assert (sfr != null);
            sourceCode = sfr.getData().getCode();
            this.codeCache.put(filePath, sourceCode);
        }
        String codeLine = "NOT FOUND!";
        try {
            StringReader code = new StringReader(sourceCode);
            BufferedReader codeReader = new BufferedReader(code);
            for (int curLine = 1; (codeLine = codeReader.readLine()) != null && curLine != lineNumber; ++curLine) {
            }
        }
        catch (IOException e) {
            log.error("Error parsing source file: {}.", (Object)filePath);
        }
        assert (codeLine != null);
        return codeLine.replace("\r", "").replace("\n", "");
    }

    @Override
    public Integer getProjectId(String ownerId, String name) {
        log.debug("Retrieving OD Project List");
        OdProjectList appList = this.getProjectPage(ownerId);
        for (OdProjectListDataItem item : appList.getData().getItems()) {
            if (!item.getName().equals(name)) continue;
            CxScanParams csp = this.getScanProbeByTeam(ownerId);
            csp.setProjectId(item.getId());
            return item.getId();
        }
        return UNKNOWN_INT;
    }

    private OdProjectList getProjectPage(String ownerId) {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        OdProjectList appList = new OdProjectList();
        boolean morePages = true;
        int curPage = 0;
        int pageSize = 50;
        long totalCount = 0L;
        long rcvItemCnt = 0L;
        while (morePages) {
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(GET_PROJECTS), HttpMethod.GET, httpEntity, OdProjectList.class, new Object[]{ownerId, curPage, pageSize});
            OdProjectList curList = (OdProjectList)response.getBody();
            if (curPage == 0) {
                totalCount = curList.getData().getTotalCount();
            }
            rcvItemCnt += (long)curList.getData().getItems().size();
            if (appList.getData() == null) {
                appList.setData(curList.getData());
            } else {
                appList.getData().getItems().addAll(curList.getData().getItems());
            }
            if (rcvItemCnt < totalCount) {
                ++curPage;
                continue;
            }
            morePages = false;
        }
        return appList;
    }

    @Override
    public void waitForScanCompletion(Integer scanId) throws CheckmarxException {
        ScanStatus scanStatus = this.getScanStatusById(scanId);
        ScanStatus.Status status = scanStatus.getStatus();
        long timer = 0L;
        try {
            while (!status.equals((Object)ScanStatus.Status.COMPLETED) && !status.equals((Object)ScanStatus.Status.FAILED)) {
                Thread.sleep(this.cxGoProperties.getScanPolling().intValue());
                scanStatus = this.getScanStatusById(scanId);
                status = scanStatus.getStatus();
                log.info("scanId: {}, status: {}, progress: {}", new Object[]{scanId, scanStatus.getStatus(), scanStatus.getProgress()});
                if ((timer += (long)this.cxGoProperties.getScanPolling().intValue()) < (long)(this.cxGoProperties.getScanTimeout() * 60000)) continue;
                log.error("Scan timeout exceeded.  {} minutes", (Object)this.cxGoProperties.getScanTimeout());
                throw new CheckmarxException("Timeout exceeded during scan");
            }
        }
        catch (InterruptedException e) {
            log.error("Thread sleep error waiting for scan status!");
        }
        log.info("scanId: {}, status: {}, progress: {}", new Object[]{scanId, scanStatus.getStatus(), scanStatus.getProgress()});
        if (status.equals((Object)ScanStatus.Status.FAILED)) {
            throw new CheckmarxException("Scan was cancelled or failed");
        }
    }

    private OdScanList getScanStatusPage(Integer projectId) {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        OdScanList appList = new OdScanList();
        boolean morePages = true;
        int curPage = 0;
        int pageSize = 50;
        long totalCount = 0L;
        long rcvItemCnt = 0L;
        while (morePages) {
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(GET_SCAN_STATUS), HttpMethod.GET, httpEntity, OdScanList.class, new Object[]{projectId, curPage, pageSize});
            OdScanList curList = (OdScanList)response.getBody();
            if (curPage == 0) {
                totalCount = curList.getData().getTotalCount().intValue();
            }
            rcvItemCnt += (long)curList.getData().getItems().size();
            if (appList.getData() == null) {
                appList.setData(curList.getData());
            } else {
                appList.getData().getItems().addAll(curList.getData().getItems());
            }
            if (rcvItemCnt < totalCount) {
                ++curPage;
                continue;
            }
            morePages = false;
        }
        return appList;
    }

    @Override
    public CxProject getProject(Integer projectId) {
        ArrayList<CxProject.CustomField> customFields = new ArrayList<CxProject.CustomField>();
        CxProject.CxProjectBuilder builder = CxProject.builder();
        builder.id(projectId);
        builder.isPublic(true);
        builder.name("CxGo Temporary Project");
        builder.teamId(null);
        builder.links(null);
        builder.customFields(customFields);
        return builder.build();
    }

    private void setupScanIdMap(Integer scanID, Integer projectID) {
        CxScanParams csp = this.getScanProbeByProject(projectID.toString());
        if (csp != null) {
            scanIdMap.put(scanID.toString(), csp);
        }
    }

    @Override
    public Integer getLastScanId(Integer projectId) {
        OdScanList appList = this.getScanStatusPage(projectId);
        for (OdScanListDataItem item : appList.getData().getItems()) {
            if (!item.getStatus().equals(CXGO_SCAN_STATUS_DONE) && !item.getStatus().equals(CXGO_SCAN_STATUS_PARTIAL) && !item.getStatus().equals(CXGO_SCAN_STATUS_COMPLETED)) continue;
            this.setupScanIdMap(item.getId(), projectId);
            log.debug("getLastScanId - Found scanId '{}', with status: '{}'", (Object)item.getId(), (Object)item.getStatus());
            return item.getId();
        }
        return UNKNOWN_INT;
    }

    private CxScanParams getScanProbeByTeam(String teamID) {
        for (CxScanParams csp : scanProbeMap) {
            if (!csp.getTeamId().equals(teamID)) continue;
            return csp;
        }
        CxScanParams csp = new CxScanParams();
        csp.setTeamId(teamID);
        scanProbeMap.add(csp);
        return csp;
    }

    private CxScanParams getScanProbeByProject(String projectID) {
        for (CxScanParams csp : scanProbeMap) {
            if (!csp.getProjectId().toString().equals(projectID)) continue;
            return csp;
        }
        return null;
    }

    public String getTeamId(String parentTeamId, String teamName) throws CheckmarxException {
        return UNKNOWN;
    }

    public Integer getScanStatus(Integer scanId) {
        return UNKNOWN_INT;
    }

    public ScanStatus getScanStatusById(Integer scanId) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.debug("Retrieving ScanStatus for Scan Id {}", (Object)scanId);
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(SCAN_STATUS), HttpMethod.GET, httpEntity, ScanStatus.class, new Object[]{scanId});
            return (ScanStatus)response.getBody();
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving the scan status for id {}.", (Object)scanId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error occurred while retrieving the scan status for id ".concat(Integer.toString(scanId)));
        }
    }

    public Scan getScanDetails(Integer scanId) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.debug("Retrieving scan with id {}", (Object)scanId);
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(SCAN), HttpMethod.GET, httpEntity, Scan.class, new Object[]{scanId});
            return (Scan)Optional.ofNullable(response.getBody()).orElseThrow(() -> new CheckmarxRuntimeException("Scan details response body is missing."));
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving the scan with id {}", (Object)scanId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error occurred while retrieving the scan with id".concat(Integer.toString(scanId)));
        }
    }

    public List<Scan> getScans() throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.debug("Retrieving all scans");
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat("/v1/scans"), HttpMethod.GET, httpEntity, Scan[].class, new Object[0]);
            return Arrays.asList((Object[])Objects.requireNonNull(response.getBody()));
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving scans");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error occurred while retrieving scans");
        }
    }

    private com.checkmarx.sdk.dto.cxgo.ScanResults getScanResults(Integer scanId) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        try {
            log.info("Retrieving Scan Results for Scan Id {} ", (Object)scanId);
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(SCAN_RESULTS), HttpMethod.GET, httpEntity, com.checkmarx.sdk.dto.cxgo.ScanResults.class, new Object[]{scanId});
            return (com.checkmarx.sdk.dto.cxgo.ScanResults)response.getBody();
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving the scan results for id {}.", (Object)scanId);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error occurred while retrieving the scan status for id ".concat(Integer.toString(scanId)));
        }
    }

    private Map<String, OdScanResultItem> getScanResultsPage(Integer projectId, Integer scanId) {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        OdScanResults appList = new OdScanResults();
        boolean morePages = true;
        int curPage = 0;
        int pageSize = 50;
        long totalCount = 0L;
        long rcvItemCnt = 0L;
        while (morePages) {
            ResponseEntity response = this.restTemplate.exchange(this.cxGoProperties.getUrl().concat(SCAN_RESULTS_ENCODED), HttpMethod.GET, httpEntity, OdScanResults.class, new Object[]{projectId, scanId, curPage, pageSize});
            OdScanResults curList = (OdScanResults)response.getBody();
            if (curPage == 0) {
                totalCount = curList.getData().getTotalCount().intValue();
            }
            rcvItemCnt += (long)curList.getData().getItems().size();
            if (appList.getData() == null) {
                appList.setData(curList.getData());
            } else {
                appList.getData().getItems().addAll(curList.getData().getItems());
            }
            if (rcvItemCnt < totalCount) {
                ++curPage;
                continue;
            }
            morePages = false;
        }
        return appList.getData().getItems().stream().collect(Collectors.toMap(odScanResultItem -> odScanResultItem.getId().toString(), Function.identity(), (thisItem, nextItem) -> nextItem));
    }

    @Autowired
    public void setCxRepoFileService(CxRepoFileService cxRepoFileService) {
        this.cxRepoFileService = cxRepoFileService;
    }

    @Override
    public Integer getProjectPresetId(Integer projectId) {
        return UNKNOWN_INT;
    }

    @Override
    public String getPresetName(Integer presetId) {
        return null;
    }

    @Override
    public String getScanConfigurationName(int configurationId) {
        return null;
    }

    @Override
    public CxScanSettings getScanSettingsDto(int projectId) {
        return null;
    }

    @Override
    public CxPropertiesBase getCxPropertiesBase() {
        return this.cxGoProperties;
    }
}

