/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.dto.cx.CxPreset;
import com.checkmarx.sdk.dto.cx.CxScanEngine;
import com.checkmarx.sdk.dto.cx.CxScanSettings;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.service.CxAuthService;
import com.checkmarx.sdk.service.ScanSettingsClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class ScanSettingsClientImpl
implements ScanSettingsClient {
    private static final Logger log = LoggerFactory.getLogger(ScanSettingsClientImpl.class);
    private static final String ID_TEMPLATE = "/{id}";
    private static final String SCAN_SETTINGS = "/sast/scanSettings";
    private static final String SCAN_SETTINGS_BY_ID = "/sast/scanSettings/{id}";
    private static final String PRESETS = "/sast/presets";
    private static final String PRESET_BY_ID = "/sast/presets/{id}";
    private static final String ENGINE_CONFIGURATIONS = "/sast/engineConfigurations";
    private static final String SCAN_CONFIGURATION_BY_ID = "/sast/engineConfigurations/{id}";
    private static final String JSON_ERROR = "Error processing JSON Response";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final RestTemplate restTemplate;
    private final CxProperties cxProperties;
    private final CxAuthService authClient;

    public ScanSettingsClientImpl(@Qualifier(value="cxRestTemplate") RestTemplate restTemplate, CxProperties cxProperties, CxAuthService authClient) {
        this.restTemplate = restTemplate;
        this.cxProperties = cxProperties;
        this.authClient = authClient;
    }

    @Override
    public int createScanSettings(int projectId, int presetId, int engineConfigId, int postActionId) {
        CxScanSettings scanSettings = CxScanSettings.builder().projectId(projectId).engineConfigurationId(engineConfigId).presetId(presetId).build();
        if (this.cxProperties.getEnablePostActionMonitor() && postActionId != 0) {
            scanSettings.setPostScanActionId(postActionId);
        }
        HttpEntity requestEntity = new HttpEntity((Object)scanSettings, (MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Creating ScanSettings for project Id {}", (Object)projectId);
        try {
            String response = (String)this.restTemplate.postForObject(this.cxProperties.getUrl().concat(SCAN_SETTINGS), (Object)requestEntity, String.class, new Object[0]);
            response = (String)StringUtils.defaultIfEmpty((CharSequence)response, (CharSequence)"");
            JSONObject obj = new JSONObject(response);
            String id = obj.get("id").toString();
            return Integer.parseInt(id);
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while creating ScanSettings for project {}, http error {}", (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error(JSON_ERROR);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return -1;
    }

    @Override
    public String getScanSettings(int projectId) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Retrieving ScanSettings for project Id {}", (Object)projectId);
        try {
            String url = this.cxProperties.getUrl().concat(SCAN_SETTINGS_BY_ID);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, String.class, new Object[]{projectId});
            return (String)response.getBody();
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving ScanSettings for project {}, http error {}", (Object)projectId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error(JSON_ERROR);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    @Override
    public CxScanSettings getScanSettingsDto(int projectId) {
        String jsonResponse = this.getScanSettings(projectId);
        CxScanSettings result = null;
        try {
            JsonNode response = objectMapper.readTree(jsonResponse);
            result = CxScanSettings.builder().projectId(projectId).presetId(response.at("/preset/id").asInt()).engineConfigurationId(response.at("/engineConfiguration/id").asInt()).build();
        }
        catch (JsonProcessingException e) {
            log.error("Error parsing scan settings response.", (Throwable)e);
        }
        return result;
    }

    @Override
    public int getPresetId(String presetName) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        int defaultPresetId = -1;
        try {
            log.info("Retrieving Cx presets");
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(PRESETS), HttpMethod.GET, httpEntity, CxPreset[].class, new Object[0]);
            CxPreset[] cxPresets = (CxPreset[])response.getBody();
            if (cxPresets == null) {
                throw new CheckmarxException("Error obtaining Team Id");
            }
            for (CxPreset cxPreset : cxPresets) {
                String currentPresetName = cxPreset.getName();
                int presetId = cxPreset.getId();
                if (currentPresetName.equalsIgnoreCase(presetName)) {
                    log.info("Found preset '{}' with ID {}", (Object)presetName, (Object)presetId);
                    return cxPreset.getId();
                }
                if (!currentPresetName.equalsIgnoreCase("Checkmarx Default")) continue;
                defaultPresetId = presetId;
            }
            log.warn("No Preset was found for '{}'", (Object)presetName);
            log.warn("Default Preset {} with ID {} will be used instead", (Object)"Checkmarx Default", (Object)defaultPresetId);
            return defaultPresetId;
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving presets");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error obtaining Preset Id");
        }
    }

    @Override
    public String getPresetName(int presetId) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        log.info("Retrieving preset name for preset Id {}", (Object)presetId);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(PRESET_BY_ID), HttpMethod.GET, requestEntity, String.class, new Object[]{presetId});
            if (response.getBody() == null) {
                return null;
            }
            JSONObject obj = new JSONObject((String)response.getBody());
            return obj.getString("name");
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving preset for preset id {}, http error {}", (Object)presetId, (Object)e.getStatusCode());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (JSONException e) {
            log.error(JSON_ERROR);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    @Override
    public int getProjectPresetId(int projectId) {
        CxScanSettings scanSettings = this.getScanSettingsDto(projectId);
        if (scanSettings == null) {
            return -1;
        }
        return scanSettings.getPresetId();
    }

    @Override
    public int getEngineConfigurationId(String configurationName) throws CheckmarxException {
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        int defaultConfigId = -1;
        try {
            log.info("Retrieving Cx engineConfigurations");
            ResponseEntity response = this.restTemplate.exchange(this.cxProperties.getUrl().concat(ENGINE_CONFIGURATIONS), HttpMethod.GET, httpEntity, CxScanEngine[].class, new Object[0]);
            CxScanEngine[] engines = (CxScanEngine[])response.getBody();
            if (engines == null) {
                throw new CheckmarxException("Error obtaining Scan configurations");
            }
            log.debug("Engine configurations found: {}.", (Object)engines.length);
            for (CxScanEngine engine : engines) {
                String engineName = engine.getName();
                int engineId = engine.getId();
                if (!engineName.equalsIgnoreCase(configurationName)) continue;
                log.info("Found xml/engine configuration {} with ID {}", (Object)configurationName, (Object)engineId);
                return engineId;
            }
            log.warn("No scan configuration found for {}", (Object)configurationName);
            log.warn("Scan Configuration {} with ID {} will be used instead", (Object)"Default Configuration", (Object)defaultConfigId);
            return defaultConfigId;
        }
        catch (HttpStatusCodeException e) {
            log.error("Error occurred while retrieving engine configurations");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new CheckmarxException("Error obtaining Configuration Id");
        }
    }

    @Override
    public String getEngineConfigurationName(int configurationId) {
        JsonNode nameNode;
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.authClient.createAuthHeaders());
        String url = this.cxProperties.getUrl() + SCAN_CONFIGURATION_BY_ID;
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JsonNode.class, new Object[]{configurationId});
        String result = null;
        if (response.getBody() != null && (nameNode = ((JsonNode)response.getBody()).get("name")) != null) {
            result = nameNode.textValue();
        }
        if (result == null) {
            log.warn("Unable to get scan configuration by ID: {}.", (Object)configurationId);
        }
        return result;
    }
}

