/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.config;

import com.cx.restclient.dto.scansummary.Severity;
import com.typesafe.config.Optional;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class ScaConfig {
    private String appUrl;
    private String apiUrl;
    private String accessControlUrl;
    private String tenant;
    @Optional
    private Map<Severity, Integer> thresholdsSeverity;
    @Optional
    private Double thresholdsScore;

    public void setThresholdsSeverity(Map<String, Object> thresholdsSeverity) {
        EnumMap<Severity, Integer> map = new EnumMap<Severity, Integer>(Severity.class);
        java.util.Optional.ofNullable(thresholdsSeverity).orElseGet(Collections::emptyMap).forEach((key, value) -> map.put(Severity.valueOf((String)key), (Integer)value));
        this.thresholdsSeverity = map;
    }

    public void setThresholdsSeverityDirectly(Map<Severity, Integer> thresholdsSeverity) {
        this.thresholdsSeverity = thresholdsSeverity;
    }

    public static ScaConfigBuilder builder() {
        return new ScaConfigBuilder();
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getAccessControlUrl() {
        return this.accessControlUrl;
    }

    public String getTenant() {
        return this.tenant;
    }

    public Map<Severity, Integer> getThresholdsSeverity() {
        return this.thresholdsSeverity;
    }

    public Double getThresholdsScore() {
        return this.thresholdsScore;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void setAccessControlUrl(String accessControlUrl) {
        this.accessControlUrl = accessControlUrl;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setThresholdsScore(Double thresholdsScore) {
        this.thresholdsScore = thresholdsScore;
    }

    public ScaConfig() {
    }

    public ScaConfig(String appUrl, String apiUrl, String accessControlUrl, String tenant, Map<Severity, Integer> thresholdsSeverity, Double thresholdsScore) {
        this.appUrl = appUrl;
        this.apiUrl = apiUrl;
        this.accessControlUrl = accessControlUrl;
        this.tenant = tenant;
        this.thresholdsSeverity = thresholdsSeverity;
        this.thresholdsScore = thresholdsScore;
    }

    public static class ScaConfigBuilder {
        private String appUrl;
        private String apiUrl;
        private String accessControlUrl;
        private String tenant;
        private Map<Severity, Integer> thresholdsSeverity;
        private Double thresholdsScore;

        ScaConfigBuilder() {
        }

        public ScaConfigBuilder appUrl(String appUrl) {
            this.appUrl = appUrl;
            return this;
        }

        public ScaConfigBuilder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public ScaConfigBuilder accessControlUrl(String accessControlUrl) {
            this.accessControlUrl = accessControlUrl;
            return this;
        }

        public ScaConfigBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public ScaConfigBuilder thresholdsSeverity(Map<Severity, Integer> thresholdsSeverity) {
            this.thresholdsSeverity = thresholdsSeverity;
            return this;
        }

        public ScaConfigBuilder thresholdsScore(Double thresholdsScore) {
            this.thresholdsScore = thresholdsScore;
            return this;
        }

        public ScaConfig build() {
            return new ScaConfig(this.appUrl, this.apiUrl, this.accessControlUrl, this.tenant, this.thresholdsSeverity, this.thresholdsScore);
        }

        public String toString() {
            return "ScaConfig.ScaConfigBuilder(appUrl=" + this.appUrl + ", apiUrl=" + this.apiUrl + ", accessControlUrl=" + this.accessControlUrl + ", tenant=" + this.tenant + ", thresholdsSeverity=" + this.thresholdsSeverity + ", thresholdsScore=" + this.thresholdsScore + ")";
        }
    }
}

