/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.ShardManager;

import com.checkmarx.sdk.ShardManager.ShardConfig;
import com.checkmarx.sdk.ShardManager.ShardSession;
import com.checkmarx.sdk.ShardManager.ShardSessionTracker;
import com.checkmarx.sdk.config.ShardProperties;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;

public class ShardManagerHTTPInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ShardManagerHTTPInterceptor.class);
    private ShardProperties shardProperties;
    private ShardSessionTracker sessionTracker;
    private static String authReq = "/cxrestapi/auth/identity/connect/token";

    public ShardManagerHTTPInterceptor(ShardProperties shardProperties, ShardSessionTracker sessionTracker) {
        this.shardProperties = shardProperties;
        this.sessionTracker = sessionTracker;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ShardSession shard = this.sessionTracker.getShardSession();
        if (!shard.getShardFound() && request.getURI().getPath().equals(authReq)) {
            this.runShardManager(this.sessionTracker.getScanRequestID(), shard);
            body = this.overrideCredentials(request, body, shard);
            ClientHttpResponse clientResp = execution.execute((HttpRequest)new ShardRequestWrapper(request, shard.getUrl()), body);
            return clientResp;
        }
        return execution.execute((HttpRequest)new ShardRequestWrapper(request, shard.getUrl()), body);
    }

    public byte[] overrideCredentials(HttpRequest request, byte[] body, ShardSession session) {
        if (request.getURI().getPath().equals(authReq) && session.getIsCredentialOverride()) {
            try {
                String bodyStr = new String(body, "UTF-8");
                String[] tokens = bodyStr.split("&");
                String newBody = "";
                for (int x = 0; x < tokens.length; ++x) {
                    if (x == 0) {
                        String usernameEnc = URLEncoder.encode(session.getUsername(), "UTF-8");
                        newBody = newBody + "username=" + usernameEnc;
                    }
                    if (x == 1) {
                        String passwordEnc = URLEncoder.encode(session.getPassword(), "UTF-8");
                        newBody = newBody + "&password=" + passwordEnc;
                    }
                    if (x <= 1) continue;
                    newBody = newBody + "&" + tokens[x];
                }
                return newBody.getBytes();
            }
            catch (UnsupportedEncodingException e) {
                log.error("Error decoding request body, returning original content - {}", (Object)ExceptionUtils.getMessage((Throwable)e), (Object)e);
                return body;
            }
        }
        return body;
    }

    public void runShardManager(String scanID, ShardSession shard) {
        Binding bindings = new Binding();
        bindings.setProperty("shardProperties", (Object)this.shardProperties);
        bindings.setProperty("cxFlowLog", (Object)log);
        bindings.setVariable("teamName", (Object)shard.getTeam());
        bindings.setVariable("projectName", (Object)shard.getProject());
        try {
            String scriptName = this.shardProperties.getScriptName();
            String scriptDir = this.shardProperties.getScriptPath();
            String[] roots = new String[]{scriptDir};
            GroovyScriptEngine gse = new GroovyScriptEngine(roots);
            gse.run(scriptName, bindings);
            shard.setShardFound(true);
            shard.setUrl((String)bindings.getVariable("url"));
            shard.setName((String)bindings.getVariable("shardName"));
            shard.setIsCredentialOverride((Boolean)bindings.getVariable("isCredentialOverride"));
            List<ShardConfig> shardProps = this.shardProperties.getShardConfig();
            for (int i = 0; i < shardProps.size(); ++i) {
                ShardConfig shardProp = shardProps.get(i);
                if (!shardProp.getName().equals(shard.getName())) continue;
                shard.setUsername(shardProp.getUsername());
                shard.setPassword(shardProp.getPassword());
            }
        }
        catch (GroovyRuntimeException | ResourceException | ScriptException | IOException e) {
            log.error("Error occurred while executing Shard Manager, returning null - {}", (Object)ExceptionUtils.getMessage((Throwable)e), (Object)e);
        }
    }

    private class ShardRequestWrapper
    extends HttpRequestWrapper {
        HttpRequest request;
        String shardAddress;

        public ShardRequestWrapper(HttpRequest request, String shardAddress) {
            super(request);
            this.request = request;
            this.shardAddress = shardAddress;
        }

        public String getMethodValue() {
            return super.getMethodValue();
        }

        public HttpHeaders getHeaders() {
            return this.request.getHeaders();
        }

        public URI getURI() {
            try {
                String rewrittenURI = this.shardAddress + super.getURI().getPath();
                if (super.getURI().getQuery() != null) {
                    rewrittenURI = rewrittenURI + "?" + super.getURI().getQuery();
                }
                return new URI(rewrittenURI);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

