/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFFunctionParameter;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.cfscript.script.JavaBlock;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserDefinedFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ACCESS_PRIVATE = 0;
    public static final int ACCESS_PACKAGE = 1;
    public static final int ACCESS_PUBLIC = 2;
    public static final int ACCESS_REMOTE = 3;
    protected CFIdentifier name;
    protected int access = -1;
    private String returnType;
    private Map<CFExpression, CFExpression> attributes;
    private CFScriptStatement body;
    protected List<CFFunctionParameter> formals;
    protected JavaBlock javaBlock;
    protected Method javaMethod;

    public UserDefinedFunction(CFIdentifier _name, byte _access, String _returnType, List<CFFunctionParameter> _formals, Map<CFExpression, CFExpression> attributes2, CFScriptStatement _body) {
        this.name = _name;
        this.access = _access;
        this.formals = _formals;
        this.attributes = attributes2;
        this.body = _body;
        this.returnType = _returnType;
    }

    public UserDefinedFunction(Method method, JavaBlock javaBlock) {
        this.name = new CFIdentifier(null, method.getName());
        this.javaBlock = javaBlock;
        this.javaMethod = method;
        this.access = 2;
        this.formals = new ArrayList<CFFunctionParameter>();
    }

    public String getTypeString() {
        return "UDF";
    }

    public List<CFFunctionParameter> getUDFFormals() {
        return this.formals;
    }

    public CFIdentifier getName() {
        return this.name;
    }

    public String getString() {
        return this.name.Decompile(0);
    }

    public boolean isJavaBlock() {
        return this.javaBlock != null;
    }

    public JavaBlock getJavaBlock() {
        return this.javaBlock;
    }

    public void setJavaBlock(JavaBlock jb) {
        this.javaBlock = jb;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void dump(PrintWriter out) {
    }

    public int getAccess() {
        return this.access;
    }

    public Map<CFExpression, CFExpression> getAttributes() {
        return this.attributes;
    }

    public CFScriptStatement getBody() {
        return this.body;
    }

    public List<CFFunctionParameter> getFormals() {
        return this.formals;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.dump(new PrintWriter(w));
        return w.toString();
    }
}

