/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFCatchStatement;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.reporting.ParseException;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFTryCatchStatement
extends CFParsedStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CFScriptStatement body;
    private List<CFCatchStatement> catchStatements;
    private CFScriptStatement finallyStatement;

    public CFScriptStatement getBody() {
        return this.body;
    }

    public List<CFCatchStatement> getCatchStatements() {
        return this.catchStatements;
    }

    public CFScriptStatement getFinallyStatement() {
        return this.finallyStatement;
    }

    public CFTryCatchStatement(Token _t1, CFScriptStatement _s1, List<CFCatchStatement> _catches, CFScriptStatement _finally) {
        super(_t1);
        this.body = _s1;
        this.catchStatements = _catches;
        this.finallyStatement = _finally;
    }

    public void validate() {
        if (this.catchStatements.size() == 0 && this.finallyStatement == null) {
            throw new ParseException(this.token, "try statement must include at least one catch clause or a finally clause.");
        }
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        this.body.checkIndirectAssignments(scriptSource);
        for (int i = 0; i < this.catchStatements.size(); ++i) {
            ((CFScriptStatement)this.catchStatements.get(i)).checkIndirectAssignments(scriptSource);
        }
    }

    @Override
    public String Decompile(int indent) {
        this.validate();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.catchStatements.size(); ++i) {
            CFCatchStatement clause = this.catchStatements.get(i);
            sb.append("catch(");
            sb.append(clause.getType());
            sb.append(" ");
            sb.append(clause.getVariable());
            sb.append(clause.getCatchBody().Decompile(0));
        }
        sb.insert(0, "try" + this.body.Decompile(0));
        return sb.toString();
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[0]);
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        ArrayList<CFScriptStatement> retval = new ArrayList<CFScriptStatement>();
        retval.add(this.body);
        retval.addAll(this.catchStatements);
        retval.add(this.finallyStatement);
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

