/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFParsedAttributeStatement;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;

public class CFPropertyStatement
extends CFParsedAttributeStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static HashSet<String> validAttributes = new HashSet();
    private boolean shorthand = false;
    private CFExpression propertyName;
    private CFExpression propertyType;

    public CFPropertyStatement(Token t, Map<CFIdentifier, CFExpression> _attributes) {
        super(t, _attributes);
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("property");
        if (!this.shorthand) {
            this.DecompileAttributes(sb);
        } else {
            sb.append(" ");
            if (this.propertyType != null) {
                sb.append(this.propertyType.Decompile(0));
                sb.append(" ");
            }
            sb.append(this.propertyName.Decompile(0));
        }
        return sb.toString();
    }

    public static HashSet<String> getValidAttributes() {
        return validAttributes;
    }

    public void setIsShortHand(boolean b) {
        this.shorthand = b;
    }

    public void setPropertyName(CFExpression cfExpression) {
        this.propertyName = cfExpression;
    }

    public void setPropertyType(CFExpression cfExpression) {
        this.propertyType = cfExpression;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        List<CFExpression> retval = super.decomposeExpression();
        if (this.propertyName != null) {
            retval.add(this.propertyName);
        }
        if (this.propertyType != null) {
            retval.add(this.propertyType);
        }
        return retval;
    }

    public CFExpression getPropertyName() {
        return this.propertyName;
    }

    public CFExpression getPropertyType() {
        return this.propertyType;
    }

    static {
        validAttributes.add("DEFAULT");
        validAttributes.add("TYPE");
        validAttributes.add("NAME");
        validAttributes.add("MAX");
        validAttributes.add("MIN");
        validAttributes.add("PATTERN");
    }
}

