/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFContext;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFFunctionParameter;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.cfscript.script.CFStatementResult;
import cfml.parsing.cfscript.script.UserDefinedFunction;
import cfml.parsing.reporting.ParseException;
import cfml.parsing.util.ArrayBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;

public class CFFuncDeclStatement
extends CFParsedStatement {
    private static final long serialVersionUID = 1L;
    private CFIdentifier name;
    private List<CFFunctionParameter> formals;
    private Map<CFExpression, CFExpression> attributes;
    private CFScriptStatement body;
    private byte access;
    private CFIdentifier returnType;

    public CFFuncDeclStatement(Token _t, CFIdentifier _name, String _access, CFIdentifier _returnType, List<CFFunctionParameter> _formals, Map<CFExpression, CFExpression> _attr, CFScriptStatement _body) {
        super(_t);
        this.name = _name;
        this.formals = _formals;
        this.body = _body;
        this.returnType = _returnType;
        this.access = (byte)2;
        if (_access != null) {
            String accessStr = _access.toUpperCase();
            if (accessStr.equals("PUBLIC")) {
                this.access = (byte)2;
            } else if (accessStr.equals("PRIVATE")) {
                this.access = 0;
            } else if (accessStr.equals("REMOTE")) {
                this.access = (byte)3;
            } else if (accessStr.equals("PACKAGE")) {
                this.access = 1;
            } else {
                throw new ParseException(this.token, "Invalid access type name \"" + _access + "\" is not supported.");
            }
        }
        this.attributes = _attr;
    }

    public CFScriptStatement getBody() {
        return this.body;
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        this.body.checkIndirectAssignments(scriptSource);
    }

    public UserDefinedFunction getUDF() {
        return new UserDefinedFunction(this.name, this.access, this.returnType.Decompile(0), this.formals, this.attributes, this.body);
    }

    public CFStatementResult Exec(CFContext context) {
        return null;
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.Indent(indent));
        if (this.name != null) {
            switch (this.access) {
                case 2: {
                    sb.append("public");
                    break;
                }
                case 0: {
                    sb.append("private");
                    break;
                }
                case 3: {
                    sb.append("remote");
                    break;
                }
                case 1: {
                    sb.append("package");
                }
            }
        }
        if (this.returnType != null) {
            sb.append(" ");
            sb.append(this.returnType.Decompile(indent));
        }
        sb.append(" function ");
        if (this.name != null) {
            sb.append(this.name.Decompile(0));
        }
        sb.append("(");
        for (int i = 0; i < this.formals.size(); ++i) {
            sb.append(this.formals.get(i));
            if (i == this.formals.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(") ");
        Iterator<CFExpression> attribs = this.attributes.keySet().iterator();
        while (attribs.hasNext()) {
            CFExpression key = attribs.next();
            sb.append(key.Decompile(0).replace('.', ':'));
            if (this.attributes.get(key) != null) {
                sb.append("=" + this.attributes.get(key).Decompile(0));
            }
            if (!attribs.hasNext()) continue;
            sb.append(" ");
        }
        sb.append(this.body.Decompile(indent + 2));
        return sb.toString();
    }

    public List<CFFunctionParameter> getFormals() {
        return this.formals;
    }

    public CFIdentifier getName() {
        return this.name;
    }

    public Map<CFExpression, CFExpression> getAttributes() {
        return this.attributes;
    }

    public byte getAccess() {
        return this.access;
    }

    public CFIdentifier getReturnType() {
        return this.returnType;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        ArrayList<CFExpression> retval = new ArrayList<CFExpression>();
        retval.add(this.name);
        for (Map.Entry<CFExpression, CFExpression> key : this.attributes.entrySet()) {
            retval.add(key.getKey());
            retval.add(key.getValue());
        }
        for (CFFunctionParameter formal : this.formals) {
            retval.add(formal.getDefaultExpression());
        }
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[]{this.body});
    }
}

