/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFParsedStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFDoWhileStatement
extends CFParsedStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CFExpression condition;
    private CFScriptStatement body;

    public CFDoWhileStatement(Token t, CFExpression _cond, CFScriptStatement _body) {
        super(t);
        this.condition = _cond;
        this.body = _body;
    }

    public CFExpression getCondition() {
        return this.condition;
    }

    public CFScriptStatement getBody() {
        return this.body;
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        this.body.checkIndirectAssignments(scriptSource);
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.Indent(indent));
        sb.append("do");
        sb.append(this.body.Decompile(indent + 2));
        sb.append("while(");
        sb.append(this.condition.Decompile(indent));
        sb.append(" ) ");
        return sb.toString();
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this.condition});
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[]{this.body});
    }
}

