/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFUnaryExpression
extends CFExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int kind;
    private CFExpression sub;

    public CFUnaryExpression(Token _t, CFExpression _sub) {
        super(_t);
        System.out.println("UNARY:" + _t);
        this.kind = _t.getType();
        this.sub = _sub;
    }

    @Override
    public byte getType() {
        return CFExpression.UNARY;
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        switch (this.kind) {
            case 74: {
                sb.append('(');
                sb.append(this.sub.Decompile(0));
                sb.append(')');
                break;
            }
            case 56: {
                sb.append('-');
                sb.append(this.sub.Decompile(0));
                break;
            }
            case 27: {
                sb.append("NOT ");
                sb.append(this.sub.Decompile(0));
                break;
            }
            case 68: {
                sb.append('!');
                sb.append(this.sub.Decompile(0));
                break;
            }
            case 67: {
                sb.append("!!");
                sb.append(this.sub.Decompile(0));
                break;
            }
            case 54: {
                sb.append('+');
                sb.append(this.sub.Decompile(0));
                break;
            }
            case 55: {
                sb.append("++");
                sb.append(this.sub.Decompile(0));
                break;
            }
            case 57: {
                sb.append("--");
                sb.append(this.sub.Decompile(0));
                break;
            }
            default: {
                sb.append(this.sub.Decompile(0));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.Decompile(0);
    }

    public int getKind() {
        return this.kind;
    }

    public CFExpression getSub() {
        return this.sub;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this.sub});
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

