/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFNewExpression
extends CFExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CFExpression componentPath;
    private List<CFExpression> args;

    public CFNewExpression(Token _t, CFExpression _component, ArrayList<CFExpression> _args) {
        super(_t);
        this.componentPath = _component;
        this.args = _args;
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(this.componentPath.Decompile(0));
        sb.append("(");
        for (int i = 0; i < this.args.size(); ++i) {
            sb.append(this.args.get(i).toString());
            if (i >= this.args.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public CFExpression getComponentPath() {
        return this.componentPath;
    }

    public List getArgs() {
        return this.args;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        ArrayList<CFExpression> retval = new ArrayList<CFExpression>();
        retval.add(this.componentPath);
        retval.addAll(this.args);
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

