/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CFMultipartIdentifier
extends CFIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<CFIdentifier> ids;

    public CFMultipartIdentifier(CFIdentifier ... identifiers) {
        super(identifiers[0].getToken());
        this.scope = identifiers[0].getScope();
        this.ids = new ArrayList<CFIdentifier>(Arrays.asList(identifiers));
    }

    @Override
    public String Decompile(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.Decompile(indent));
        for (int i = 1; i < this.ids.size(); ++i) {
            sb.append(".").append(this.ids.get(i).Decompile(0));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.Decompile(0);
    }

    public void addIdentifier(CFIdentifier id) {
        this.ids.add(id);
    }

    public List<CFIdentifier> getIds() {
        return this.ids;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        ArrayList<CFExpression> retval = new ArrayList<CFExpression>();
        retval.addAll(this.ids);
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

