/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFJavaMethodExpression
extends CFExpression {
    private static final long serialVersionUID = 1L;
    private CFExpression name;
    private ArrayList<CFExpression> args;
    private boolean _onMissingMethod = false;

    public CFJavaMethodExpression(Token _t, CFExpression _name, ArrayList<CFExpression> _args) {
        super(_t);
        this.name = _name;
        this.args = _args;
    }

    @Override
    public byte getType() {
        return CFExpression.FUNCTION;
    }

    public String getFunctionName() {
        return ((CFIdentifier)this.name).getName();
    }

    public ArrayList<CFExpression> getArguments() {
        return this.args;
    }

    public boolean isOnMethodMissing() {
        return this._onMissingMethod;
    }

    public void setOnMethodMissing() {
        this._onMissingMethod = true;
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name.Decompile(indent));
        sb.append("(");
        for (int i = 0; i < this.args.size(); ++i) {
            sb.append(this.args.get(i).toString());
            if (i >= this.args.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public CFExpression getName() {
        return this.name;
    }

    public ArrayList<CFExpression> getArgs() {
        return this.args;
    }

    public boolean isOnMissingMethod() {
        return this._onMissingMethod;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        ArrayList<CFExpression> retval = new ArrayList<CFExpression>();
        retval.add(this.name);
        retval.addAll(this.args);
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

