/*
 * Decompiled with CFR 0.152.
 */
package co.ceryle.radiorealbutton;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import co.ceryle.radiorealbutton.ConversionHelper;

public class RoundedCornerLayout
extends FrameLayout {
    private float cornerRadius;
    private int strokeColor = -7829368;
    private int strokeSize;
    private boolean hasStroke = false;

    public RoundedCornerLayout(Context context) {
        super(context);
        this.init(context);
    }

    public RoundedCornerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public RoundedCornerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    @TargetApi(value=21)
    public RoundedCornerLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.cornerRadius = ConversionHelper.dpToPx(context, 1.0f);
        this.setLayerType(1, null);
    }

    protected void dispatchDraw(Canvas canvas) {
        int count = canvas.save();
        Path path = new Path();
        path.addRoundRect(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), this.cornerRadius, this.cornerRadius, Path.Direction.CW);
        canvas.clipPath(path, Region.Op.REPLACE);
        canvas.clipPath(path);
        super.dispatchDraw(canvas);
        canvas.restoreToCount(count);
        if (this.hasStroke) {
            Rect rect = canvas.getClipBounds();
            RectF rectF = new RectF((float)this.strokeSize, (float)this.strokeSize, (float)(rect.right - this.strokeSize), (float)(rect.bottom - this.strokeSize));
            Path clipPath = new Path();
            float corner = this.cornerRadius - (float)this.strokeSize;
            clipPath.addRoundRect(rectF, corner, corner, Path.Direction.CW);
            canvas.clipPath(clipPath, Region.Op.DIFFERENCE);
            Paint p_stroke = new Paint();
            p_stroke.setAntiAlias(true);
            p_stroke.setColor(this.strokeColor);
            p_stroke.setStyle(Paint.Style.FILL);
            canvas.drawRoundRect(new RectF(rect), this.cornerRadius, this.cornerRadius, p_stroke);
        }
    }

    void setCornerRadius(float radius) {
        this.cornerRadius = radius;
        this.requestLayout();
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new ButtonOutlineProvider());
        }
    }

    public void setStroke(boolean hasStroke) {
        this.hasStroke = hasStroke;
        this.invalidate();
    }

    public void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.invalidate();
    }

    public void setStrokeSize(int strokeSize) {
        this.strokeSize = strokeSize;
        this.invalidate();
    }

    @TargetApi(value=21)
    private class ButtonOutlineProvider
    extends ViewOutlineProvider {
        private ButtonOutlineProvider() {
        }

        public void getOutline(View view, Outline outline) {
            outline.setRoundRect(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight(), RoundedCornerLayout.this.cornerRadius);
        }
    }
}

