/*
 * Decompiled with CFR 0.152.
 */
package com.github.captain_miao.optroundcardview;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.captain_miao.optroundcardview.RoundRectDrawable;

@TargetApi(value=21)
public class OptRoundRectDrawable
extends RoundRectDrawable {
    public static final int FLAG_LEFT_TOP_CORNER = 1;
    public static final int FLAG_RIGHT_TOP_CORNER = 2;
    public static final int FLAG_LEFT_BOTTOM_CORNER = 4;
    public static final int FLAG_RIGHT_BOTTOM_CORNER = 8;
    private boolean leftTopRect = false;
    private boolean rightTopRect = false;
    private boolean leftBottomRect = false;
    private boolean rightBottomRect = false;

    public OptRoundRectDrawable(int backgroundColor, float radius, int cornerFlag) {
        super(backgroundColor, radius);
        this.leftTopRect = (1 & cornerFlag) == 0;
        this.rightTopRect = (2 & cornerFlag) == 0;
        this.leftBottomRect = (4 & cornerFlag) == 0;
        this.rightBottomRect = (8 & cornerFlag) == 0;
    }

    public OptRoundRectDrawable(int backgroundColor, float radius) {
        super(backgroundColor, radius);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.leftTopRect) {
            canvas.drawRect(this.buildLeftTopRect(), this.mPaint);
        }
        if (this.rightTopRect) {
            canvas.drawRect(this.buildRightTopRect(), this.mPaint);
        }
        if (this.rightBottomRect) {
            canvas.drawRect(this.buildRightBottomRect(), this.mPaint);
        }
        if (this.leftBottomRect) {
            canvas.drawRect(this.buildLeftBottomRect(), this.mPaint);
        }
    }

    @Override
    public void getOutline(Outline outline) {
        if (this.buildConvexPath().isConvex()) {
            outline.setConvexPath(this.buildConvexPath());
        } else {
            super.getOutline(outline);
        }
    }

    private RectF buildLeftTopRect() {
        RectF rectF = new RectF();
        rectF.left = this.mBoundsF.left;
        rectF.top = this.mBoundsF.top;
        rectF.right = this.mBoundsF.left + this.mRadius * 2.0f;
        rectF.bottom = this.mBoundsF.top + this.mRadius * 2.0f;
        return rectF;
    }

    private RectF buildRightTopRect() {
        RectF rectF = new RectF();
        rectF.left = this.mBoundsF.right - this.mRadius * 2.0f;
        rectF.top = this.mBoundsF.top;
        rectF.right = this.mBoundsF.right;
        rectF.bottom = this.mBoundsF.top + this.mRadius * 2.0f;
        return rectF;
    }

    private RectF buildRightBottomRect() {
        RectF rectF = new RectF();
        rectF.left = this.mBoundsF.right - this.mRadius * 2.0f;
        rectF.top = this.mBoundsF.bottom - this.mRadius * 2.0f;
        rectF.right = this.mBoundsF.right;
        rectF.bottom = this.mBoundsF.bottom;
        return rectF;
    }

    private RectF buildLeftBottomRect() {
        RectF rectF = new RectF();
        rectF.left = this.mBoundsF.left;
        rectF.top = this.mBoundsF.bottom - this.mRadius * 2.0f;
        rectF.right = this.mBoundsF.left + this.mRadius * 2.0f;
        rectF.bottom = this.mBoundsF.bottom;
        return rectF;
    }

    protected Path buildConvexPath() {
        RectF rectF;
        Path path = new Path();
        path.moveTo(this.mBoundsF.left, (this.mBoundsF.top + this.mBoundsF.bottom) / 2.0f);
        path.lineTo(this.mBoundsF.left, this.mBoundsF.top + this.mRadius);
        if (this.leftTopRect) {
            path.lineTo(this.mBoundsF.left, this.mBoundsF.top);
        } else {
            rectF = new RectF(this.mBoundsF.left, this.mBoundsF.top, this.mBoundsF.left + this.mRadius * 2.0f, this.mBoundsF.top + this.mRadius * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
        }
        path.lineTo(this.mBoundsF.right - this.mRadius, this.mBoundsF.top);
        if (this.rightTopRect) {
            path.lineTo(this.mBoundsF.right, this.mBoundsF.top);
        } else {
            rectF = new RectF(this.mBoundsF.right - this.mRadius * 2.0f, this.mBoundsF.top, this.mBoundsF.right, this.mBoundsF.top + this.mRadius * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
        }
        path.lineTo(this.mBoundsF.right, this.mBoundsF.bottom - this.mRadius);
        if (this.rightBottomRect) {
            path.lineTo(this.mBoundsF.right, this.mBoundsF.bottom);
        } else {
            rectF = new RectF(this.mBoundsF.right - this.mRadius * 2.0f, this.mBoundsF.bottom - this.mRadius * 2.0f, this.mBoundsF.right, this.mBoundsF.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
        }
        path.lineTo(this.mBoundsF.left + this.mRadius, this.mBoundsF.bottom);
        if (this.leftBottomRect) {
            path.lineTo(this.mBoundsF.left, this.mBoundsF.bottom);
        } else {
            rectF = new RectF(this.mBoundsF.left, this.mBoundsF.bottom - this.mRadius * 2.0f, this.mBoundsF.left + this.mRadius * 2.0f, this.mBoundsF.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
        }
        path.close();
        return path;
    }

    protected int getColor() {
        return this.mPaint.getColor();
    }

    @Override
    public void setRadius(float radius) {
        super.setRadius(radius);
    }

    @Override
    public void setColor(int color2) {
        super.setColor(color2);
    }

    public void showCorner(boolean leftTop, boolean rightTop, boolean leftBottom, boolean rightBottom) {
        this.leftTopRect = !leftTop;
        this.rightTopRect = !rightTop;
        this.leftBottomRect = !leftBottom;
        this.rightBottomRect = !rightBottom;
        this.invalidateSelf();
    }

    public void showLeftTopRect(boolean show) {
        this.leftTopRect = show;
        this.invalidateSelf();
    }

    public void showRightTopRect(boolean show) {
        this.rightTopRect = show;
        this.invalidateSelf();
    }

    public void showRightBottomRect(boolean show) {
        this.rightBottomRect = show;
        this.invalidateSelf();
    }

    public void showLeftBottomRect(boolean show) {
        this.leftBottomRect = show;
        this.invalidateSelf();
    }
}

