/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.ctc;

import com.github.caciocavallosilano.cacio.ctc.CTCGraphicsDevice;
import com.github.caciocavallosilano.cacio.peer.managed.FullScreenWindowFactory;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class CTCGraphicsConfiguration
extends GraphicsConfiguration {
    private final ColorModel model;
    private final Raster raster;
    private CTCGraphicsDevice device;

    CTCGraphicsConfiguration(CTCGraphicsDevice dev) {
        BufferedImage bufferedImage = new BufferedImage(FullScreenWindowFactory.getScreenDimension().width, FullScreenWindowFactory.getScreenDimension().height, 2);
        this.device = dev;
        this.model = bufferedImage.getColorModel();
        this.raster = bufferedImage.getRaster().createCompatibleWritableRaster(1, 1);
    }

    @Override
    public GraphicsDevice getDevice() {
        return this.device;
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Rectangle getBounds() {
        Dimension d = FullScreenWindowFactory.getScreenDimension();
        return new Rectangle(0, 0, d.width, d.height);
    }

    @Override
    public BufferedImage createCompatibleImage(int width, int height) {
        WritableRaster wr = this.raster.createCompatibleWritableRaster(width, height);
        return new BufferedImage(this.model, wr, this.model.isAlphaPremultiplied(), null);
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return AffineTransform.getScaleInstance(1.0, 1.0);
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }
}

