/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ListPeer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class CacioListPeer
extends CacioComponentPeer<List, JScrollPane>
implements ListPeer {
    private JList list;

    public CacioListPeer(List awtC, PlatformWindowFactory pwf) {
        super(awtC, pwf);
    }

    @Override
    JScrollPane initSwingComponent() {
        this.list = new JList(new DefaultListModel());
        JScrollPane pane = new JScrollPane(this.list);
        return pane;
    }

    @Override
    void postInitSwingComponent() {
        super.postInitSwingComponent();
        List theList = (List)this.getAWTComponent();
        int itemCount = theList.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            this.add(theList.getItem(i), i);
        }
        this.setMultipleMode(theList.isMultipleMode());
        this.list.addListSelectionListener(new SelectionListener());
    }

    private DefaultListModel getModel() {
        DefaultListModel m = (DefaultListModel)this.list.getModel();
        return m;
    }

    @Override
    public void add(String item, int index) {
        if (index < 0) {
            this.getModel().addElement(item);
        } else {
            this.getModel().add(index, item);
        }
    }

    @Override
    public void delItems(int start, int end) {
        this.getModel().removeRange(start, end);
    }

    @Override
    public Dimension getMinimumSize(int rows) {
        FontMetrics fm = this.getFontMetrics(((List)this.getAWTComponent()).getFont());
        return new Dimension(20 + fm.stringWidth("0123456789abcde"), fm.getHeight() * rows);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(5);
    }

    @Override
    public Dimension getPreferredSize(int rows) {
        Dimension minSize = this.getMinimumSize(5);
        Dimension actualSize = ((JScrollPane)this.getSwingComponent()).getPreferredSize();
        if (actualSize.width < minSize.width) {
            actualSize.width = minSize.width;
        }
        if (actualSize.height < actualSize.height) {
            actualSize.height = minSize.height;
        }
        return actualSize;
    }

    @Override
    public Dimension getPreferredSize() {
        int rows = this.getModel().getSize();
        return this.getPreferredSize(rows < 5 ? 5 : rows);
    }

    @Override
    public void makeVisible(int index) {
        this.list.ensureIndexIsVisible(index);
    }

    @Override
    public void select(int index) {
        this.list.setSelectedIndex(index);
    }

    @Override
    public void deselect(int index) {
        this.list.removeSelectionInterval(index, index);
    }

    @Override
    public void removeAll() {
        ListSelectionModel m = this.list.getSelectionModel();
        m.clearSelection();
    }

    @Override
    public int[] getSelectedIndexes() {
        return this.list.getSelectedIndices();
    }

    @Override
    public void setMultipleMode(boolean multiple) {
        int mode = multiple ? 2 : 0;
        this.list.setSelectionMode(mode);
    }

    @Override
    protected void handleMouseEvent(MouseEvent e) {
        super.handleMouseEvent(e);
        if (e.getID() == 502 && e.getClickCount() == 2) {
            this.getToolkit().getSystemEventQueue().postEvent(new ActionEvent(this.getAWTComponent(), 1001, "" + this.getModel().getElementAt(this.list.locationToIndex(e.getPoint()))));
        }
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.list.setEnabled(e);
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            for (int index = e.getFirstIndex(); index < e.getLastIndex(); ++index) {
                CacioListPeer.this.getToolkit().getSystemEventQueue().postEvent(new ItemEvent((ItemSelectable)CacioListPeer.this.getAWTComponent(), 701, CacioListPeer.this.getModel().getElementAt(index), CacioListPeer.this.list.isSelectedIndex(index) ? 1 : 2));
            }
        }
    }
}

