/*
 * Decompiled with CFR 0.152.
 */
package com.github.burrunan.s3cache.internal;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004J7\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00160\u0018\u00a2\u0006\u0002\b\u0019H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/github/burrunan/s3cache/internal/Stopwatch;", "", "()V", "bytes", "", "getBytes", "()J", "bytesProcessed", "Ljava/util/concurrent/atomic/AtomicLong;", "elapsed", "getElapsed", "elapsedTime", "startCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "starts", "", "getStarts", "()I", "", "increment", "duration", "invoke", "T", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(JLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "s3-build-cache"})
public final class Stopwatch {
    @NotNull
    private AtomicLong elapsedTime = new AtomicLong();
    @NotNull
    private AtomicInteger startCount = new AtomicInteger();
    @NotNull
    private AtomicLong bytesProcessed = new AtomicLong();

    public final long getElapsed() {
        return this.elapsedTime.get();
    }

    public final int getStarts() {
        return this.startCount.get();
    }

    public final long getBytes() {
        return this.bytesProcessed.get();
    }

    public final void bytesProcessed(long bytes) {
        this.bytesProcessed.addAndGet(bytes);
    }

    public final void increment(long duration, long bytesProcessed) {
        this.elapsedTime.addAndGet(duration);
        this.bytesProcessed.addAndGet(bytesProcessed);
        this.startCount.incrementAndGet();
    }

    public static /* synthetic */ void increment$default(Stopwatch stopwatch, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = 0L;
        }
        stopwatch.increment(l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T invoke(long bytes, @NotNull Function1<? super Stopwatch, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        long startTime = System.currentTimeMillis();
        this.startCount.incrementAndGet();
        if (bytes != 0L) {
            this.bytesProcessed.addAndGet(bytes);
        }
        try {
            Object object = action.invoke((Object)this);
            return (T)object;
        }
        finally {
            this.elapsedTime.addAndGet(System.currentTimeMillis() - startTime);
        }
    }

    public static /* synthetic */ Object invoke$default(Stopwatch stopwatch, long l, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        return stopwatch.invoke(l, function1);
    }
}

