/*
 * Decompiled with CFR 0.152.
 */
package com.github.burrunan.s3cache.internal;

import com.github.burrunan.s3cache.AwsS3BuildCache;
import com.github.burrunan.s3cache.internal.AwsS3BuildCacheService;
import com.github.burrunan.s3cache.internal.AwsS3BuildCacheServiceFactoryKt;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0014\u0010\u000e\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0014\u0010\u0010\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u001e\u0010\u0011\u001a\u00020\r*\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/github/burrunan/s3cache/internal/AwsS3BuildCacheServiceFactory;", "Lorg/gradle/caching/BuildCacheServiceFactory;", "Lcom/github/burrunan/s3cache/AwsS3BuildCache;", "()V", "createBuildCacheService", "Lorg/gradle/caching/BuildCacheService;", "config", "describer", "Lorg/gradle/caching/BuildCacheServiceFactory$Describer;", "createS3Client", "Lsoftware/amazon/awssdk/services/s3/S3Client;", "kotlin.jvm.PlatformType", "verifyConfig", "", "addCredentials", "Lsoftware/amazon/awssdk/services/s3/S3ClientBuilder;", "addHttpHeaders", "describe", "name", "", "value", "", "transferAcceleration", "s3-build-cache"})
@SourceDebugExtension(value={"SMAP\nAwsS3BuildCacheServiceFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsS3BuildCacheServiceFactory.kt\ncom/github/burrunan/s3cache/internal/AwsS3BuildCacheServiceFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1#2:154\n1863#3,2:155\n1863#3,2:157\n*S KotlinDebug\n*F\n+ 1 AwsS3BuildCacheServiceFactory.kt\ncom/github/burrunan/s3cache/internal/AwsS3BuildCacheServiceFactory\n*L\n92#1:155,2\n148#1:157,2\n*E\n"})
public final class AwsS3BuildCacheServiceFactory
implements BuildCacheServiceFactory<AwsS3BuildCache> {
    @NotNull
    public BuildCacheService createBuildCacheService(@NotNull AwsS3BuildCache config, @NotNull BuildCacheServiceFactory.Describer describer) {
        BuildCacheServiceFactory.Describer describer2;
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        Intrinsics.checkNotNullParameter((Object)describer, (String)"describer");
        AwsS3BuildCacheServiceFactoryKt.access$getLogger$p().debug("Start creating S3 build cache service");
        BuildCacheServiceFactory.Describer $this$createBuildCacheService_u24lambda_u240 = describer2 = describer;
        boolean bl = false;
        $this$createBuildCacheService_u24lambda_u240.type("AWS S3");
        this.describe($this$createBuildCacheService_u24lambda_u240, "Region", config.getRegion());
        this.describe($this$createBuildCacheService_u24lambda_u240, "Bucket", config.getBucket());
        this.describe($this$createBuildCacheService_u24lambda_u240, "Reduced Redundancy", config.isReducedRedundancy());
        this.describe($this$createBuildCacheService_u24lambda_u240, "Prefix", config.getPrefix());
        this.describe($this$createBuildCacheService_u24lambda_u240, "KMS Key ID", config.getKmsKeyId());
        this.describe($this$createBuildCacheService_u24lambda_u240, "Endpoint", config.getEndpoint());
        this.describe($this$createBuildCacheService_u24lambda_u240, "Transfer Acceleration", config.getTransferAcceleration());
        this.verifyConfig(config);
        Function0 function0 = (Function0)new Function0<S3Client>(this, config){
            final /* synthetic */ AwsS3BuildCacheServiceFactory this$0;
            final /* synthetic */ AwsS3BuildCache $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(0);
            }

            public final S3Client invoke() {
                S3Client s3Client = AwsS3BuildCacheServiceFactory.access$createS3Client(this.this$0, this.$config);
                Intrinsics.checkNotNullExpressionValue((Object)s3Client, (String)"createS3Client(config)");
                return s3Client;
            }
        };
        String string = config.getBucket();
        Intrinsics.checkNotNull((Object)string);
        return new AwsS3BuildCacheService((Function0<? extends S3Client>)function0, string, config.getPrefix(), config.getKmsKeyId(), config.isReducedRedundancy(), config.getMaximumCachedObjectLength(), config.getShowStatistics(), config.getShowStatisticsWhenImpactExceeds(), config.getShowStatisticsWhenSavingsExceeds(), config.getShowStatisticsWhenWasteExceeds(), config.getShowStatisticsWhenTransferExceeds());
    }

    private final void describe(BuildCacheServiceFactory.Describer $this$describe, String name, Object value) {
        if (value != null) {
            $this$describe.config(name, value.toString());
        }
    }

    private final void verifyConfig(AwsS3BuildCache config) {
        CharSequence charSequence = config.getRegion();
        if (!(!(charSequence == null || charSequence.length() == 0))) {
            boolean $i$a$-check-AwsS3BuildCacheServiceFactory$verifyConfig$32 = false;
            String $i$a$-check-AwsS3BuildCacheServiceFactory$verifyConfig$32 = "S3 build cache has no AWS region configured";
            throw new IllegalStateException($i$a$-check-AwsS3BuildCacheServiceFactory$verifyConfig$32.toString());
        }
        charSequence = config.getBucket();
        if (!(!(charSequence == null || charSequence.length() == 0))) {
            boolean bl = false;
            String string = "S3 build cache has no bucket configured";
            throw new IllegalStateException(string.toString());
        }
    }

    private final S3Client createS3Client(AwsS3BuildCache config) {
        S3ClientBuilder $this$createS3Client_u24lambda_u245 = S3Client.builder();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$createS3Client_u24lambda_u245, (String)"createS3Client$lambda$5");
        this.addHttpHeaders($this$createS3Client_u24lambda_u245, config);
        this.addCredentials($this$createS3Client_u24lambda_u245, config);
        $this$createS3Client_u24lambda_u245.region(Region.of((String)config.getRegion()));
        if (config.getForcePathStyle()) {
            $this$createS3Client_u24lambda_u245.forcePathStyle(Boolean.valueOf(true));
        }
        String string = config.getEndpoint();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            String endpoint = StringsKt.startsWith$default((String)it, (String)"http", (boolean)false, (int)2, null) ? it : "https://" + it;
            S3ClientBuilder cfr_ignored_0 = (S3ClientBuilder)$this$createS3Client_u24lambda_u245.endpointOverride(URI.create(endpoint));
        }
        this.transferAcceleration($this$createS3Client_u24lambda_u245, config);
        Iterable $this$forEach$iv = config.getS3ClientActions$s3_build_cache();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Action it = (Action)element$iv;
            boolean bl3 = false;
            it.execute((Object)$this$createS3Client_u24lambda_u245);
        }
        return (S3Client)$this$createS3Client_u24lambda_u245.build();
    }

    private final void addHttpHeaders(S3ClientBuilder $this$addHttpHeaders, AwsS3BuildCache config) {
        block0: {
            Map<String, String> map = config.getHeaders();
            if (map == null) break block0;
            Map<String, String> headers = map;
            boolean bl = false;
            S3ClientBuilder cfr_ignored_0 = (S3ClientBuilder)$this$addHttpHeaders.overrideConfiguration(new Consumer(headers){
                final /* synthetic */ Map<String, String> $headers;
                {
                    this.$headers = $headers;
                }

                public final void accept(ClientOverrideConfiguration.Builder it) {
                    for (Map.Entry<String, String> entry : this.$headers.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (key == null || value == null) continue;
                        it.putHeader(key, value);
                    }
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void addCredentials(S3ClientBuilder $this$addCredentials, AwsS3BuildCache config) {
        block8: {
            block7: {
                if (config.getLookupDefaultAwsCredentials()) {
                    return;
                }
                if (config.getCredentialsProvider() == null) break block7;
                v0 = config.getCredentialsProvider();
                break block8;
            }
            v1 = config.getAwsAccessKeyId();
            if (v1 == null) {
                v1 = "";
            }
            if (!(StringsKt.isBlank((CharSequence)v1) == false)) ** GOTO lbl-1000
            v2 = config.getAwsSecretKey();
            if (v2 == null) {
                v2 = "";
            }
            if (StringsKt.isBlank((CharSequence)v2) == false) {
                var4_3 = config.getSessionToken();
                v0 = (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)((AwsCredentials)((var4_3 == null || var4_3.length() == 0) != false ? AwsBasicCredentials.create((String)config.getAwsAccessKeyId(), (String)config.getAwsSecretKey()) : AwsSessionCredentials.create((String)config.getAwsAccessKeyId(), (String)config.getAwsSecretKey(), (String)config.getSessionToken()))));
            } else if (config.getAwsWebIdentityTokenFile() != null) {
                v3 = WebIdentityTokenFileCredentialsProvider.builder().roleArn(config.getAwsRoleARN());
                v4 = config.getAwsWebIdentityTokenFile();
                Intrinsics.checkNotNull((Object)v4);
                v0 = (AwsCredentialsProvider)v3.webIdentityTokenFile(Paths.get(v4, new String[0])).build();
            } else {
                var4_3 = config.getAwsProfile();
                v0 = (var4_3 == null || StringsKt.isBlank((CharSequence)var4_3) != false) == false ? (AwsCredentialsProvider)ProfileCredentialsProvider.create((String)config.getAwsProfile()) : (AwsCredentialsProvider)AnonymousCredentialsProvider.create();
            }
        }
        credentials = v0;
        $this$addCredentials.credentialsProvider(credentials);
    }

    private final void transferAcceleration(S3ClientBuilder $this$transferAcceleration, AwsS3BuildCache config) {
        S3Configuration.Builder builder;
        S3Configuration.Builder $this$transferAcceleration_u24lambda_u248 = builder = S3Configuration.builder();
        boolean bl = false;
        $this$transferAcceleration_u24lambda_u248.accelerateModeEnabled(config.getTransferAcceleration());
        Iterable $this$forEach$iv = config.getS3ConfigurationActions$s3_build_cache();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Action it = (Action)element$iv;
            boolean bl2 = false;
            it.execute((Object)$this$transferAcceleration_u24lambda_u248);
        }
        S3Configuration s3Conf = (S3Configuration)builder.build();
        $this$transferAcceleration.serviceConfiguration(s3Conf);
    }

    public static final /* synthetic */ S3Client access$createS3Client(AwsS3BuildCacheServiceFactory $this, AwsS3BuildCache config) {
        return $this.createS3Client(config);
    }
}

