/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideType;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class RequestManagerGenerator {
    private static final String GLIDE_QUALIFIED_NAME = "com.bumptech.glide.Glide";
    private static final String REQUEST_MANAGER_QUALIFIED_NAME = "com.bumptech.glide.RequestManager";
    private static final String LIFECYCLE_QUALIFIED_NAME = "com.bumptech.glide.manager.Lifecycle";
    private static final String REQUEST_MANAGER_TREE_NODE_QUALIFIED_NAME = "com.bumptech.glide.manager.RequestManagerTreeNode";
    private static final ClassName CONTEXT_CLASS_NAME = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
    private static final String GENERATED_REQUEST_MANAGER_SIMPLE_NAME = "GlideRequests";
    private ProcessingEnvironment processingEnv;
    private final ProcessorUtil processorUtil;
    private final ClassName requestManagerClassName;
    private final TypeElement lifecycleType;
    private final TypeElement requestManagerTreeNodeType;
    private final TypeElement glideType;
    private final TypeElement requestManagerType;
    private final TypeElement requestBuilderType;
    private ClassName generatedRequestBuilderClassName;

    RequestManagerGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processingEnv = processingEnv;
        this.processorUtil = processorUtil;
        Elements elementUtils = processingEnv.getElementUtils();
        this.requestManagerType = elementUtils.getTypeElement(REQUEST_MANAGER_QUALIFIED_NAME);
        this.requestManagerClassName = ClassName.get((TypeElement)this.requestManagerType);
        this.lifecycleType = elementUtils.getTypeElement(LIFECYCLE_QUALIFIED_NAME);
        this.requestManagerTreeNodeType = elementUtils.getTypeElement(REQUEST_MANAGER_TREE_NODE_QUALIFIED_NAME);
        this.requestBuilderType = elementUtils.getTypeElement("com.bumptech.glide.RequestBuilder");
        this.glideType = elementUtils.getTypeElement(GLIDE_QUALIFIED_NAME);
    }

    TypeSpec generate(String generatedCodePackageName, @Nullable TypeSpec requestOptions, TypeSpec requestBuilder, Set<String> glideExtensions) {
        this.generatedRequestBuilderClassName = ClassName.get((String)generatedCodePackageName, (String)requestBuilder.name, (String[])new String[0]);
        return TypeSpec.classBuilder((String)GENERATED_REQUEST_MANAGER_SIMPLE_NAME).superclass((TypeName)this.requestManagerClassName).addJavadoc("Includes all additions from methods in {@link $T}s\nannotated with {@link $T}\n\n<p>Generated code, do not modify\n", new Object[]{GlideExtension.class, GlideType.class}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"deprecation"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(this.generateAsMethod(generatedCodePackageName, requestBuilder)).addMethod(this.generateCallSuperConstructor()).addMethods(this.generateExtensionRequestManagerMethods(glideExtensions)).addMethods(this.generateRequestManagerRequestManagerMethodOverrides(generatedCodePackageName)).addMethods(this.generateRequestManagerRequestBuilderMethodOverrides()).addMethods((Iterable)FluentIterable.from(Collections.singletonList(this.generateOverrideSetRequestOptions(generatedCodePackageName, requestOptions))).filter(Predicates.notNull())).build();
    }

    private MethodSpec generateCallSuperConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)this.glideType), (String)"glide", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)this.lifecycleType), (String)"lifecycle", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)this.requestManagerTreeNodeType), (String)"treeNode", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)CONTEXT_CLASS_NAME, (String)"context", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addStatement("super(glide, lifecycle, treeNode, context)", new Object[0]).build();
    }

    private MethodSpec generateAsMethod(String generatedCodePackageName, TypeSpec requestBuilder) {
        TypeVariableName resourceType = TypeVariableName.get((String)"ResourceType");
        ParameterizedTypeName classOfResouceType = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{resourceType});
        ClassName generatedRequestBuilderClassName = ClassName.get((String)generatedCodePackageName, (String)requestBuilder.name, (String[])new String[0]);
        ParameterizedTypeName requestBuilderOfResourceType = ParameterizedTypeName.get((ClassName)generatedRequestBuilderClassName, (TypeName[])new TypeName[]{resourceType});
        return MethodSpec.methodBuilder((String)"as").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addAnnotation(this.processorUtil.checkResult()).addAnnotation(this.processorUtil.nonNull()).addTypeVariable(TypeVariableName.get((String)"ResourceType")).returns((TypeName)requestBuilderOfResourceType).addParameter(classOfResouceType.annotated(new AnnotationSpec[]{AnnotationSpec.builder((ClassName)this.processorUtil.nonNull()).build()}), "resourceClass", new Modifier[0]).addStatement("return new $T<>(glide, this, resourceClass, context)", new Object[]{this.generatedRequestBuilderClassName}).build();
    }

    private List<MethodSpec> generateRequestManagerRequestManagerMethodOverrides(final String generatedPackageName) {
        return FluentIterable.from(this.processorUtil.findInstanceMethodsReturning(this.requestManagerType, this.requestManagerType)).transform((Function)new Function<ExecutableElement, MethodSpec>(){

            public MethodSpec apply(@Nullable ExecutableElement input) {
                return RequestManagerGenerator.this.generateRequestManagerRequestManagerMethodOverride(generatedPackageName, input);
            }
        }).toList();
    }

    private MethodSpec generateRequestManagerRequestManagerMethodOverride(String generatedPackageName, ExecutableElement method) {
        ClassName generatedRequestManagerName = ClassName.get((String)generatedPackageName, (String)GENERATED_REQUEST_MANAGER_SIMPLE_NAME, (String[])new String[0]);
        MethodSpec.Builder returns = this.processorUtil.overriding(method).addAnnotation(this.processorUtil.nonNull()).returns((TypeName)generatedRequestManagerName);
        return returns.addCode(ProcessorUtil.generateCastingSuperCall((TypeName)generatedRequestManagerName, returns.build())).build();
    }

    private List<MethodSpec> generateRequestManagerRequestBuilderMethodOverrides() {
        TypeMirror rawRequestBuilder = this.processingEnv.getTypeUtils().erasure(this.requestBuilderType.asType());
        return FluentIterable.from(this.processorUtil.findInstanceMethodsReturning(this.requestManagerType, rawRequestBuilder)).filter((Predicate)new Predicate<ExecutableElement>(){

            public boolean apply(ExecutableElement input) {
                return !input.getSimpleName().toString().equals("as");
            }
        }).transform((Function)new Function<ExecutableElement, MethodSpec>(){

            public MethodSpec apply(ExecutableElement input) {
                return RequestManagerGenerator.this.generateRequestManagerRequestBuilderMethodOverride(input);
            }
        }).toList();
    }

    private MethodSpec generateRequestManagerRequestBuilderMethodOverride(ExecutableElement methodToOverride) {
        TypeMirror typeArgument = ((DeclaredType)methodToOverride.getReturnType()).getTypeArguments().get(0);
        ParameterizedTypeName generatedRequestBuilderOfType = ParameterizedTypeName.get((ClassName)this.generatedRequestBuilderClassName, (TypeName[])new TypeName[]{ClassName.get((TypeMirror)typeArgument)});
        MethodSpec.Builder builder = this.processorUtil.overriding(methodToOverride).returns((TypeName)generatedRequestBuilderOfType);
        builder.addCode(ProcessorUtil.generateCastingSuperCall((TypeName)generatedRequestBuilderOfType, builder.build()));
        for (AnnotationMirror annotationMirror : methodToOverride.getAnnotationMirrors()) {
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        return builder.build();
    }

    private List<MethodSpec> generateExtensionRequestManagerMethods(Set<String> glideExtensions) {
        List<ExecutableElement> requestManagerExtensionMethods = this.processorUtil.findAnnotatedElementsInClasses(glideExtensions, GlideType.class);
        return Lists.transform(requestManagerExtensionMethods, (Function)new Function<ExecutableElement, MethodSpec>(){

            public MethodSpec apply(ExecutableElement input) {
                return RequestManagerGenerator.this.generateAdditionalRequestManagerMethod(input);
            }
        });
    }

    private MethodSpec generateAdditionalRequestManagerMethod(ExecutableElement extensionMethod) {
        if (extensionMethod.getReturnType().getKind() == TypeKind.VOID) {
            return this.generateAdditionalRequestManagerMethodLegacy(extensionMethod);
        }
        return this.generateAdditionalRequestManagerMethodNew(extensionMethod);
    }

    private MethodSpec generateAdditionalRequestManagerMethodLegacy(ExecutableElement extensionMethod) {
        String returnType = (String)this.processorUtil.findClassValuesFromAnnotationOnClassAsNames(extensionMethod, GlideType.class).iterator().next();
        ClassName returnTypeClassName = ClassName.bestGuess((String)returnType);
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)this.generatedRequestBuilderClassName, (TypeName[])new TypeName[]{returnTypeClassName});
        return MethodSpec.methodBuilder((String)extensionMethod.getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)parameterizedTypeName).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(extensionMethod)).addAnnotation(this.processorUtil.nonNull()).addAnnotation(this.processorUtil.checkResult()).addStatement("$T requestBuilder = this.as($T.class)", new Object[]{parameterizedTypeName, returnTypeClassName}).addStatement("$T.$N(requestBuilder)", new Object[]{extensionMethod.getEnclosingElement(), extensionMethod.getSimpleName()}).addStatement("return requestBuilder", new Object[0]).build();
    }

    private MethodSpec generateAdditionalRequestManagerMethodNew(ExecutableElement extensionMethod) {
        String returnType = (String)this.processorUtil.findClassValuesFromAnnotationOnClassAsNames(extensionMethod, GlideType.class).iterator().next();
        ClassName returnTypeClassName = ClassName.bestGuess((String)returnType);
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)this.generatedRequestBuilderClassName, (TypeName[])new TypeName[]{returnTypeClassName});
        return MethodSpec.methodBuilder((String)extensionMethod.getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)parameterizedTypeName).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(extensionMethod)).addAnnotation(this.processorUtil.nonNull()).addAnnotation(this.processorUtil.checkResult()).addStatement("return ($T) $T.$N(this.as($T.class))", new Object[]{parameterizedTypeName, extensionMethod.getEnclosingElement(), extensionMethod.getSimpleName(), returnTypeClassName}).build();
    }

    @Nullable
    private MethodSpec generateOverrideSetRequestOptions(String generatedCodePackageName, @Nullable TypeSpec generatedRequestOptions) {
        if (generatedRequestOptions == null) {
            return null;
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement requestOptionsType = elementUtils.getTypeElement("com.bumptech.glide.request.RequestOptions");
        String generatedRequestOptionsQualifiedName = generatedCodePackageName + "." + generatedRequestOptions.name;
        String methodName = "setRequestOptions";
        String parameterName = "toSet";
        return MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)requestOptionsType), (String)parameterName, (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).beginControlFlow("if ($N instanceof $L)", new Object[]{parameterName, generatedRequestOptionsQualifiedName}).addStatement("super.$N($N)", new Object[]{methodName, parameterName}).nextControlFlow("else", new Object[0]).addStatement("super.setRequestOptions(new $L().apply($N))", new Object[]{generatedRequestOptionsQualifiedName, parameterName}).endControlFlow().build();
    }
}

