/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.annotation.compiler.Index;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class IndexerGenerator {
    private static final String INDEXER_NAME_PREFIX = "GlideIndexer_";
    private static final int MAXIMUM_FILE_NAME_LENGTH = 255;
    private final ProcessorUtil processorUtil;

    IndexerGenerator(ProcessorUtil processorUtil) {
        this.processorUtil = processorUtil;
    }

    TypeSpec generate(List<TypeElement> types) {
        ArrayList<TypeElement> modules = new ArrayList<TypeElement>();
        ArrayList<TypeElement> extensions = new ArrayList<TypeElement>();
        for (TypeElement element : types) {
            if (this.processorUtil.isExtension(element)) {
                extensions.add(element);
                continue;
            }
            if (this.processorUtil.isLibraryGlideModule(element)) {
                modules.add(element);
                continue;
            }
            throw new IllegalArgumentException("Unrecognized type: " + String.valueOf(element));
        }
        if (!modules.isEmpty() && !extensions.isEmpty()) {
            throw new IllegalArgumentException("Given both modules and extensions, expected one or the other. Modules: " + String.valueOf(modules) + " Extensions: " + String.valueOf(extensions));
        }
        if (!modules.isEmpty()) {
            return this.generate(types, GlideModule.class);
        }
        return this.generate(types, GlideExtension.class);
    }

    /*
     * WARNING - void declaration
     */
    private TypeSpec generate(List<TypeElement> libraryModules, Class<? extends Annotation> annotation) {
        void var6_10;
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder(Index.class);
        String value = IndexerGenerator.getAnnotationValue(annotation);
        for (TypeElement typeElement : libraryModules) {
            annotationBuilder.addMember(value, "$S", new Object[]{ClassName.get((TypeElement)typeElement).toString()});
        }
        StringBuilder indexerNameBuilder = new StringBuilder(INDEXER_NAME_PREFIX + annotation.getSimpleName() + "_");
        for (TypeElement element : libraryModules) {
            indexerNameBuilder.append(element.getQualifiedName().toString().replace(".", "_"));
            indexerNameBuilder.append("_");
        }
        String string = (indexerNameBuilder = new StringBuilder(indexerNameBuilder.substring(0, indexerNameBuilder.length() - 1))).toString();
        if (string.length() >= 255 - INDEXER_NAME_PREFIX.length()) {
            String string2 = INDEXER_NAME_PREFIX + UUID.nameUUIDFromBytes(string.getBytes()).toString().replace("-", "_");
        }
        return TypeSpec.classBuilder((String)var6_10).addAnnotation(annotationBuilder.build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
    }

    private static String getAnnotationValue(Class<? extends Annotation> annotation) {
        if (annotation == GlideModule.class) {
            return "modules";
        }
        if (annotation == GlideExtension.class) {
            return "extensions";
        }
        throw new IllegalArgumentException("Unrecognized annotation: " + String.valueOf(annotation));
    }
}

