/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.GlideType;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.collect.FluentIterable;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableSet;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class GlideExtensionValidator {
    private final ProcessingEnvironment processingEnvironment;
    private final ProcessorUtil processorUtil;

    GlideExtensionValidator(ProcessingEnvironment processingEnvironment, ProcessorUtil processorUtil) {
        this.processingEnvironment = processingEnvironment;
        this.processorUtil = processorUtil;
    }

    void validateExtension(TypeElement typeElement) {
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new IllegalArgumentException("RequestOptionsExtensions must be public, including: " + GlideExtensionValidator.getName(typeElement));
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                GlideExtensionValidator.validateExtensionConstructor(element);
                continue;
            }
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getAnnotation(GlideOption.class) != null) {
                this.validateGlideOption(executableElement);
                continue;
            }
            if (executableElement.getAnnotation(GlideType.class) == null) continue;
            this.validateGlideType(executableElement);
        }
    }

    private static String getQualifiedMethodName(ExecutableElement executableElement) {
        return GlideExtensionValidator.getEnclosingClassName(executableElement) + "#" + GlideExtensionValidator.getName(executableElement);
    }

    private static String getEnclosingClassName(Element element) {
        return element.getEnclosingElement().toString();
    }

    private static String getName(Element element) {
        return element.toString();
    }

    private static void validateExtensionConstructor(Element element) {
        if (!element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new IllegalArgumentException("RequestOptionsExtensions must be public, with private constructors and only static methods. Found a non-private constructor in: " + GlideExtensionValidator.getEnclosingClassName(element));
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (!executableElement.getParameters().isEmpty()) {
            throw new IllegalArgumentException("RequestOptionsExtensions must be public, with private constructors and only static methods. Found parameters in the constructor of: " + GlideExtensionValidator.getEnclosingClassName(element));
        }
    }

    private void validateGlideOption(ExecutableElement executableElement) {
        this.validateGlideOptionAnnotations(executableElement);
        GlideExtensionValidator.validateGlideOptionParameters(executableElement);
        TypeMirror returnType = executableElement.getReturnType();
        if (!GlideExtensionValidator.isBaseRequestOptions(returnType)) {
            throw new IllegalArgumentException("@GlideOption methods should return a BaseRequestOptions<?> object, but " + GlideExtensionValidator.getQualifiedMethodName(executableElement) + " returns " + returnType + ". If you're using old style @GlideOption methods, your method may have a void return type, but doing so is deprecated and support will be removed in a future version");
        }
        this.validateGlideOptionOverride(executableElement);
    }

    private void validateGlideOptionAnnotations(ExecutableElement executableElement) {
        this.validateAnnotatedNonNull(executableElement);
    }

    private static void validateGlideOptionParameters(ExecutableElement executableElement) {
        if (executableElement.getParameters().isEmpty()) {
            throw new IllegalArgumentException("@GlideOption methods must take a BaseRequestOptions<?> object as their first parameter, but " + GlideExtensionValidator.getQualifiedMethodName(executableElement) + " has none");
        }
        VariableElement first = executableElement.getParameters().get(0);
        TypeMirror expected = first.asType();
        if (!GlideExtensionValidator.isBaseRequestOptions(expected)) {
            throw new IllegalArgumentException("@GlideOption methods must take a BaseRequestOptions<?> object as their first parameter, but the first parameter in " + GlideExtensionValidator.getQualifiedMethodName(executableElement) + " is " + expected);
        }
    }

    private static boolean isBaseRequestOptions(TypeMirror typeMirror) {
        return typeMirror.toString().equals("com.bumptech.glide.request.BaseRequestOptions<?>");
    }

    private void validateGlideOptionOverride(ExecutableElement element) {
        int overrideType = this.processorUtil.getOverrideType(element);
        boolean isOverridingBaseRequestOptionsMethod = this.isMethodInBaseRequestOptions(element);
        if (isOverridingBaseRequestOptionsMethod && overrideType == 0) {
            throw new IllegalArgumentException("Accidentally attempting to override a method in BaseRequestOptions. Add an 'override' value in the @GlideOption annotation if this is intentional. Offending method: " + GlideExtensionValidator.getQualifiedMethodName(element));
        }
        if (!isOverridingBaseRequestOptionsMethod && overrideType != 0) {
            throw new IllegalArgumentException("Requested to override an existing method in BaseRequestOptions, but no such method was found. Offending method: " + GlideExtensionValidator.getQualifiedMethodName(element));
        }
    }

    private boolean isMethodInBaseRequestOptions(ExecutableElement toFind) {
        TypeElement requestOptionsType = this.processingEnvironment.getElementUtils().getTypeElement("com.bumptech.glide.request.BaseRequestOptions");
        List<String> toFindParameterNames = GlideExtensionValidator.getComparableParameterNames(toFind, true);
        String toFindSimpleName = toFind.getSimpleName().toString();
        for (Element element : requestOptionsType.getEnclosedElements()) {
            List<String> parameterNamesInBase;
            ExecutableElement inBase;
            if (element.getKind() != ElementKind.METHOD || !toFindSimpleName.equals((inBase = (ExecutableElement)element).getSimpleName().toString()) || !(parameterNamesInBase = GlideExtensionValidator.getComparableParameterNames(inBase, false)).equals(toFindParameterNames)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getComparableParameterNames(ExecutableElement element, boolean skipFirst) {
        List<? extends VariableElement> parameters = element.getParameters();
        if (skipFirst) {
            parameters = parameters.subList(1, parameters.size());
        }
        ArrayList<String> result = new ArrayList<String>(parameters.size());
        for (VariableElement variableElement : parameters) {
            result.add(variableElement.asType().toString());
        }
        return result;
    }

    private void validateGlideType(ExecutableElement executableElement) {
        TypeMirror returnType = executableElement.getReturnType();
        this.validateGlideTypeAnnotations(executableElement);
        if (!this.isRequestBuilder(returnType) || !this.typeMatchesExpected(returnType, executableElement)) {
            String expectedClassName = this.getGlideTypeValue(executableElement);
            throw new IllegalArgumentException("@GlideType methods should return a RequestBuilder<" + expectedClassName + "> object, but " + GlideExtensionValidator.getQualifiedMethodName(executableElement) + " returns: " + returnType + ". If you're using old style @GlideType methods, your method may have a void return type, but doing so is deprecated and support will be removed in a future version");
        }
        GlideExtensionValidator.validateGlideTypeParameters(executableElement);
    }

    private String getGlideTypeValue(ExecutableElement executableElement) {
        return this.processorUtil.findClassValuesFromAnnotationOnClassAsNames(executableElement, GlideType.class).iterator().next();
    }

    private boolean typeMatchesExpected(TypeMirror returnType, ExecutableElement executableElement) {
        if (!(returnType instanceof DeclaredType)) {
            return false;
        }
        List<? extends TypeMirror> typeArguments = ((DeclaredType)returnType).getTypeArguments();
        if (typeArguments.size() != 1) {
            return false;
        }
        TypeMirror argument = typeArguments.get(0);
        String expected = this.getGlideTypeValue(executableElement);
        return argument.toString().equals(expected);
    }

    private boolean isRequestBuilder(TypeMirror typeMirror) {
        TypeMirror toCompare = this.processingEnvironment.getTypeUtils().erasure(typeMirror);
        return toCompare.toString().equals("com.bumptech.glide.RequestBuilder");
    }

    private static void validateGlideTypeParameters(ExecutableElement executableElement) {
        if (executableElement.getParameters().size() != 1) {
            throw new IllegalArgumentException("@GlideType methods must take a RequestBuilder object as their first and only parameter, but given multiple for: " + GlideExtensionValidator.getQualifiedMethodName(executableElement));
        }
        VariableElement first = executableElement.getParameters().get(0);
        TypeMirror argumentType = first.asType();
        if (!argumentType.toString().startsWith("com.bumptech.glide.RequestBuilder")) {
            throw new IllegalArgumentException("@GlideType methods must take a RequestBuilder object as their first and only parameter, but given: " + argumentType + " for: " + GlideExtensionValidator.getQualifiedMethodName(executableElement));
        }
    }

    private void validateGlideTypeAnnotations(ExecutableElement executableElement) {
        this.validateAnnotatedNonNull(executableElement);
    }

    private void validateAnnotatedNonNull(ExecutableElement executableElement) {
        ImmutableSet<String> annotationNames = FluentIterable.from(executableElement.getAnnotationMirrors()).transform(new Function<AnnotationMirror, String>(){

            @Override
            public String apply(AnnotationMirror input) {
                return input.getAnnotationType().asElement().toString();
            }
        }).toSet();
        boolean noNonNull = true;
        for (ClassName nonNull : ProcessorUtil.nonNulls()) {
            if (!annotationNames.contains(nonNull.reflectionName())) continue;
            noNonNull = false;
            break;
        }
        if (noNonNull) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, GlideExtensionValidator.getQualifiedMethodName(executableElement) + " is missing the " + ProcessorUtil.nonNull().reflectionName() + " annotation, please add it to ensure that your extension methods are always returning non-null values");
        }
    }
}

