/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.annotation.compiler.RequestOptionsExtensionGenerator;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.base.Joiner;
import com.bumptech.glide.repackaged.com.google.common.base.Predicate;
import com.bumptech.glide.repackaged.com.google.common.collect.FluentIterable;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableList;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableSet;
import com.bumptech.glide.repackaged.com.google.common.collect.Lists;
import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeBlock;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterizedTypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeVariableName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.WildcardTypeName;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class RequestBuilderGenerator {
    private static final ImmutableSet<String> EXCLUDED_METHODS_FROM_BASE_REQUEST_OPTIONS = ImmutableSet.of("clone", "apply", "autoLock", "lock", "autoClone");
    private final ProcessingEnvironment processingEnv;
    private final ProcessorUtil processorUtil;
    private final TypeVariableName transcodeTypeName;
    private final TypeElement requestOptionsType;
    private final TypeElement requestBuilderType;
    private ClassName generatedRequestBuilderClassName;
    private ClassName requestOptionsClassName;
    private ParameterizedTypeName generatedRequestBuilderOfTranscodeType;

    RequestBuilderGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processingEnv = processingEnv;
        this.processorUtil = processorUtil;
        this.requestBuilderType = processingEnv.getElementUtils().getTypeElement("com.bumptech.glide.RequestBuilder");
        this.transcodeTypeName = TypeVariableName.get("TranscodeType");
        this.requestOptionsType = processingEnv.getElementUtils().getTypeElement("com.bumptech.glide.request.RequestOptions");
    }

    TypeSpec generate(String generatedCodePackageName, Set<String> glideExtensionClassNames, TypeSpec generatedOptions) {
        this.requestOptionsClassName = generatedOptions != null ? ClassName.get(generatedCodePackageName, generatedOptions.name, new String[0]) : ClassName.get("com.bumptech.glide.request", "BaseRequestOptions", new String[0]);
        this.generatedRequestBuilderClassName = ClassName.get(generatedCodePackageName, "GlideRequest", new String[0]);
        this.generatedRequestBuilderOfTranscodeType = ParameterizedTypeName.get(this.generatedRequestBuilderClassName, this.transcodeTypeName);
        RequestOptionsExtensionGenerator requestOptionsExtensionGenerator = new RequestOptionsExtensionGenerator(this.generatedRequestBuilderOfTranscodeType, this.processorUtil);
        ParameterizedTypeName requestBuilderOfTranscodeType = ParameterizedTypeName.get(ClassName.get("com.bumptech.glide", "RequestBuilder", new String[0]), this.transcodeTypeName);
        List<MethodSpec> requestOptionsExtensionMethods = requestOptionsExtensionGenerator.generateInstanceMethodsForExtensions(glideExtensionClassNames);
        return TypeSpec.classBuilder("GlideRequest").addJavadoc("Contains all public methods from {@link $T}, all options from\n", this.requestBuilderType).addJavadoc("{@link $T} and all generated options from\n", this.requestOptionsType).addJavadoc("{@link $T} in annotated methods in\n", GlideOption.class).addJavadoc("{@link $T} annotated classes.\n", GlideExtension.class).addJavadoc("\n", new Object[0]).addJavadoc("<p>Generated code, do not modify.\n", new Object[0]).addJavadoc("\n", new Object[0]).addJavadoc("@see $T\n", this.requestBuilderType).addJavadoc("@see $T\n", this.requestOptionsType).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "unused").addMember("value", "$S", "deprecation").build()).addModifiers(Modifier.PUBLIC).addTypeVariable(this.transcodeTypeName).superclass(requestBuilderOfTranscodeType).addSuperinterface((Type)((Object)Cloneable.class)).addMethods(this.generateConstructors()).addMethod(this.generateDownloadOnlyRequestMethod()).addMethods(this.generateGeneratedRequestOptionsEquivalents(requestOptionsExtensionMethods, generatedOptions)).addMethods(this.generateRequestBuilderOverrides()).addMethods(requestOptionsExtensionMethods).build();
    }

    private List<MethodSpec> generateGeneratedRequestOptionsEquivalents(final List<MethodSpec> requestOptionsExtensionMethods, TypeSpec generatedOptions) {
        if (generatedOptions == null) {
            return Collections.emptyList();
        }
        return FluentIterable.from(generatedOptions.methodSpecs).filter(new Predicate<MethodSpec>(){

            @Override
            public boolean apply(MethodSpec input) {
                return RequestBuilderGenerator.this.isUsefulGeneratedRequestOption(requestOptionsExtensionMethods, input);
            }
        }).transform(new Function<MethodSpec, MethodSpec>(){

            @Override
            public MethodSpec apply(MethodSpec input) {
                return RequestBuilderGenerator.this.generateGeneratedRequestOptionEquivalent(input);
            }
        }).toList();
    }

    private boolean isUsefulGeneratedRequestOption(List<MethodSpec> requestOptionsExtensionMethods, MethodSpec requestOptionsMethod) {
        return !EXCLUDED_METHODS_FROM_BASE_REQUEST_OPTIONS.contains(requestOptionsMethod.name) && requestOptionsMethod.hasModifier(Modifier.PUBLIC) && !requestOptionsMethod.hasModifier(Modifier.STATIC) && requestOptionsMethod.returnType.toString().equals(this.requestOptionsClassName.toString()) && !this.isExtensionMethod(requestOptionsExtensionMethods, requestOptionsMethod);
    }

    private boolean isExtensionMethod(List<MethodSpec> requestOptionsExtensionMethods, final MethodSpec requestOptionsMethod) {
        return FluentIterable.from(requestOptionsExtensionMethods).anyMatch(new Predicate<MethodSpec>(){

            @Override
            public boolean apply(MethodSpec input) {
                return input.name.equals(requestOptionsMethod.name) && input.parameters.equals(requestOptionsMethod.parameters);
            }
        });
    }

    private MethodSpec generateGeneratedRequestOptionEquivalent(MethodSpec requestOptionMethod) {
        CodeBlock callRequestOptionsMethod = CodeBlock.builder().add(".$N(", requestOptionMethod.name).add(FluentIterable.from(requestOptionMethod.parameters).transform(new Function<ParameterSpec, String>(){

            @Override
            public String apply(ParameterSpec input) {
                return input.name;
            }
        }).join(Joiner.on(", ")), new Object[0]).add(");\n", new Object[0]).build();
        MethodSpec.Builder result = MethodSpec.methodBuilder(requestOptionMethod.name).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(this.requestOptionsClassName, requestOptionMethod)).addModifiers(Modifier.PUBLIC).varargs(requestOptionMethod.varargs).addAnnotations(FluentIterable.from(requestOptionMethod.annotations).filter(new Predicate<AnnotationSpec>(){

            @Override
            public boolean apply(AnnotationSpec input) {
                return !input.type.equals(TypeName.get(Override.class)) && !input.type.equals(TypeName.get(SafeVarargs.class)) && !input.type.equals(TypeName.get(SuppressWarnings.class));
            }
        }).toList()).addTypeVariables(requestOptionMethod.typeVariables).addParameters(requestOptionMethod.parameters).returns(this.generatedRequestBuilderOfTranscodeType).addCode("return ($T) super", this.generatedRequestBuilderOfTranscodeType).addCode(callRequestOptionsMethod);
        AnnotationSpec suppressWarnings = this.buildSuppressWarnings(requestOptionMethod);
        if (suppressWarnings != null) {
            result.addAnnotation(suppressWarnings);
        }
        return result.build();
    }

    private AnnotationSpec buildSuppressWarnings(MethodSpec requestOptionMethod) {
        HashSet<String> suppressions = new HashSet<String>();
        if (requestOptionMethod.annotations.contains(AnnotationSpec.builder(SuppressWarnings.class).build())) {
            for (AnnotationSpec annotation : requestOptionMethod.annotations) {
                if (!annotation.type.equals(TypeName.get(SuppressWarnings.class))) continue;
                List<CodeBlock> codeBlocks = annotation.members.get("value");
                suppressions.addAll(FluentIterable.from(codeBlocks).transform(new Function<CodeBlock, String>(){

                    @Override
                    public String apply(CodeBlock input) {
                        return input.toString();
                    }
                }).toSet());
            }
        }
        if (requestOptionMethod.annotations.contains(AnnotationSpec.builder(SafeVarargs.class).build())) {
            suppressions.add("unchecked");
            suppressions.add("varargs");
        }
        if (suppressions.isEmpty()) {
            return null;
        }
        ArrayList suppressionsList = new ArrayList(suppressions);
        Collections.sort(suppressionsList);
        AnnotationSpec.Builder builder = AnnotationSpec.builder(SuppressWarnings.class);
        for (String suppression : suppressionsList) {
            builder.addMember("value", "$S", suppression);
        }
        return builder.build();
    }

    private List<MethodSpec> generateRequestBuilderOverrides() {
        TypeMirror rawRequestBuilderType = this.processingEnv.getTypeUtils().erasure(this.requestBuilderType.asType());
        return Lists.transform(this.processorUtil.findInstanceMethodsReturning(this.requestBuilderType, rawRequestBuilderType), new Function<ExecutableElement, MethodSpec>(){

            @Override
            public MethodSpec apply(ExecutableElement input) {
                return RequestBuilderGenerator.this.generateRequestBuilderOverride(input);
            }
        });
    }

    private MethodSpec generateRequestBuilderOverride(ExecutableElement methodToOverride) {
        TypeMirror typeArgument = ((DeclaredType)methodToOverride.getReturnType()).getTypeArguments().get(0);
        ParameterizedTypeName generatedRequestBuilderOfType = ParameterizedTypeName.get(this.generatedRequestBuilderClassName, ClassName.get(typeArgument));
        MethodSpec.Builder builder = ProcessorUtil.overriding(methodToOverride).returns(generatedRequestBuilderOfType);
        builder.addCode(CodeBlock.builder().add("return ($T) super.$N(", generatedRequestBuilderOfType, methodToOverride.getSimpleName()).add(FluentIterable.from(builder.build().parameters).transform(new Function<ParameterSpec, String>(){

            @Override
            public String apply(ParameterSpec input) {
                return input.name;
            }
        }).join(Joiner.on(", ")), new Object[0]).add(");\n", new Object[0]).build());
        for (AnnotationMirror annotationMirror : methodToOverride.getAnnotationMirrors()) {
            builder = builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
        if (methodToOverride.isVarArgs()) {
            builder = builder.addModifiers(Modifier.FINAL).addAnnotation(SafeVarargs.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "varargs").build());
        }
        return builder.build();
    }

    private List<MethodSpec> generateConstructors() {
        ParameterizedTypeName classOfTranscodeType = ParameterizedTypeName.get(ClassName.get(Class.class), this.transcodeTypeName);
        WildcardTypeName wildcardOfObject = WildcardTypeName.subtypeOf(Object.class);
        ParameterizedTypeName requestBuilderOfWildcardOfObject = ParameterizedTypeName.get(ClassName.get(this.requestBuilderType), wildcardOfObject);
        MethodSpec firstConstructor = MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder(classOfTranscodeType, "transcodeClass", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(requestBuilderOfWildcardOfObject, "other", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addStatement("super($N, $N)", "transcodeClass", "other").build();
        ClassName context = ClassName.get("android.content", "Context", new String[0]);
        ClassName glide = ClassName.get("com.bumptech.glide", "Glide", new String[0]);
        ClassName requestManager = ClassName.get("com.bumptech.glide", "RequestManager", new String[0]);
        MethodSpec secondConstructor = MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder(glide, "glide", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(requestManager, "requestManager", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(classOfTranscodeType, "transcodeClass", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(context, "context", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addStatement("super($N, $N ,$N, $N)", "glide", "requestManager", "transcodeClass", "context").build();
        return ImmutableList.of(firstConstructor, secondConstructor);
    }

    private MethodSpec generateDownloadOnlyRequestMethod() {
        ParameterizedTypeName generatedRequestBuilderOfFile = ParameterizedTypeName.get(this.generatedRequestBuilderClassName, ClassName.get(File.class));
        return MethodSpec.methodBuilder("getDownloadOnlyRequest").addAnnotation(Override.class).addAnnotation(this.processorUtil.checkResult()).addAnnotation(this.processorUtil.nonNull()).returns(generatedRequestBuilderOfFile).addModifiers(Modifier.PROTECTED).addStatement("return new $T<>($T.class, $N).apply($N)", this.generatedRequestBuilderClassName, File.class, "this", "DOWNLOAD_ONLY_OPTIONS").build();
    }
}

