/*
 * Decompiled with CFR 0.152.
 */
package com.github.bringking.maven.requirejs;

import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class MojoErrorReporter
implements ErrorReporter {
    private String defaultFilename;
    private boolean acceptWarn;
    private Log log;
    private int warningCount;
    private int errorCount;

    public MojoErrorReporter(Log log, boolean acceptWarnings) {
        this.log = log;
        this.acceptWarn = acceptWarnings;
    }

    public void setDefaultFileName(String filename) {
        this.defaultFilename = filename.length() == 0 ? null : filename;
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        String fullMessage = this.newMessage(message, sourceName, line, lineSource, lineOffset);
        this.log.error((CharSequence)fullMessage);
        ++this.errorCount;
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        throw new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.acceptWarn) {
            String fullMessage = this.newMessage(message, sourceName, line, lineSource, lineOffset);
            this.log.warn((CharSequence)fullMessage);
            ++this.warningCount;
        }
    }

    public int getErrorCnt() {
        return this.errorCount;
    }

    public int getWarningCnt() {
        return this.warningCount;
    }

    private String newMessage(String message, String sourceName, int line, String lineSource, int lineOffset) {
        StringBuilder back = new StringBuilder();
        if (sourceName == null || sourceName.length() == 0) {
            sourceName = this.defaultFilename;
        }
        if (sourceName != null) {
            back.append(sourceName).append(":line ").append(line).append(":column ").append(lineOffset).append(':');
        }
        if (message != null && message.length() != 0) {
            back.append(message);
        } else {
            back.append("unknown error");
        }
        if (lineSource != null && lineSource.length() != 0) {
            back.append("\n\t").append(lineSource);
        }
        return back.toString();
    }
}

