/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import java.lang.reflect.Field;
import java.util.logging.FileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileHandlerExpose {
    private static final Logger LOG = LoggerFactory.getLogger((String)FileHandlerExpose.class.getSimpleName());
    private static Field fileNameField;

    FileHandlerExpose() {
    }

    public String getCurrentFileName(FileHandler fileHandler) {
        if (fileHandler == null) {
            throw new IllegalArgumentException("fileHandler must not be null");
        }
        Field field = this.getFileNameField(fileHandler);
        if (field != null) {
            try {
                return (String)field.get(fileHandler);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Cant read 'fileName' field value from {}", (Object)fileHandler, (Object)e);
            }
        }
        return null;
    }

    private synchronized Field getFileNameField(FileHandler fileHandler) {
        if (fileNameField == null) {
            try {
                fileNameField = fileHandler.getClass().getDeclaredField("fileName");
                fileNameField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                LOG.warn("Could not find field 'fileName' inside class {}", fileHandler.getClass());
            }
        }
        return fileNameField;
    }
}

