/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.Marker;
import pl.brightinventions.slf4android.LogLevel;

class AndroidLoggerAdapter
implements Logger {
    private static final Level TRACE_LEVEL = LogLevel.TRACE.getUtilLogLevel();
    private static final Level DEBUG_LEVEL = LogLevel.DEBUG.getUtilLogLevel();
    private static final Level INFO_LEVEL = LogLevel.INFO.getUtilLogLevel();
    private static final Level WARN_LEVEL = LogLevel.WARNING.getUtilLogLevel();
    private static final Level ERROR_LEVEL = LogLevel.ERROR.getUtilLogLevel();
    private final java.util.logging.Logger logger;

    public AndroidLoggerAdapter(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public void trace(String msg) {
        this.print(TRACE_LEVEL, msg);
    }

    private void print(Level level, String msg) {
        this.logger.log(level, msg);
    }

    public void trace(String format, Object arg) {
        this.print(TRACE_LEVEL, format, arg);
    }

    private void print(Level level, String format, Object arg) {
        this.logger.log(level, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.print(TRACE_LEVEL, format, arg1, arg2);
    }

    private void print(Level level, String format, Object arg1, Object arg2) {
        this.logger.log(level, format, new Object[]{arg1, arg2});
    }

    public void trace(String format, Object ... arguments) {
        this.print(TRACE_LEVEL, format, arguments);
    }

    private void print(Level level, String format, Object[] args) {
        this.logger.log(level, format, args);
    }

    public void trace(String msg, Throwable t) {
        this.print(TRACE_LEVEL, msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(TRACE_LEVEL);
    }

    private boolean isEnabled(Level level) {
        return this.logger.isLoggable(level);
    }

    public void trace(Marker marker, String msg) {
        this.print(TRACE_LEVEL, marker, msg);
    }

    private void print(Level level, Marker marker, String msg) {
        this.print(level, msg, marker);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.print(TRACE_LEVEL, marker, format, arg);
    }

    private void print(Level level, Marker marker, String format, Object arg) {
        this.print(level, format, marker, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.print(TRACE_LEVEL, marker, format, arg1, arg2);
    }

    private void print(Level level, Marker marker, String format, Object arg1, Object arg2) {
        this.print(level, format, new Object[]{marker, arg1, arg2});
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.print(TRACE_LEVEL, marker, format, (Object)argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.print(TRACE_LEVEL, marker, msg, t);
    }

    private void print(Level level, Marker marker, String msg, Throwable t) {
        this.print(level, msg, new Object[]{marker, t});
    }

    public void debug(String msg) {
        this.print(DEBUG_LEVEL, msg);
    }

    public void debug(String format, Object arg) {
        this.print(DEBUG_LEVEL, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.print(DEBUG_LEVEL, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.print(DEBUG_LEVEL, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.print(DEBUG_LEVEL, msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(DEBUG_LEVEL);
    }

    public void debug(Marker marker, String msg) {
        this.print(DEBUG_LEVEL, marker, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.print(DEBUG_LEVEL, marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.print(DEBUG_LEVEL, marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.print(DEBUG_LEVEL, marker, format, (Object)arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.print(DEBUG_LEVEL, marker, msg, t);
    }

    public void info(String msg) {
        this.print(INFO_LEVEL, msg);
    }

    public void info(String format, Object arg) {
        this.print(INFO_LEVEL, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.print(INFO_LEVEL, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.print(INFO_LEVEL, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.print(INFO_LEVEL, msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(INFO_LEVEL);
    }

    public void info(Marker marker, String msg) {
        this.print(INFO_LEVEL, marker, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.print(INFO_LEVEL, marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.print(INFO_LEVEL, marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.print(INFO_LEVEL, marker, format, (Object)arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.print(INFO_LEVEL, marker, msg, t);
    }

    public void warn(String msg) {
        this.print(WARN_LEVEL, msg);
    }

    public void warn(String format, Object arg) {
        this.print(WARN_LEVEL, format, arg);
    }

    public void warn(String format, Object ... arguments) {
        this.print(WARN_LEVEL, format, arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.print(WARN_LEVEL, format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.print(WARN_LEVEL, msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(WARN_LEVEL);
    }

    public void warn(Marker marker, String msg) {
        this.print(WARN_LEVEL, marker, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.print(WARN_LEVEL, marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.print(WARN_LEVEL, marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.print(WARN_LEVEL, marker, format, (Object)arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.print(WARN_LEVEL, marker, msg, t);
    }

    public void error(String msg) {
        this.print(ERROR_LEVEL, msg);
    }

    public void error(String format, Object arg) {
        this.print(ERROR_LEVEL, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.print(ERROR_LEVEL, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.print(ERROR_LEVEL, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.print(ERROR_LEVEL, msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(ERROR_LEVEL);
    }

    public void error(Marker marker, String msg) {
        this.print(ERROR_LEVEL, marker, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.print(ERROR_LEVEL, marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.print(ERROR_LEVEL, marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.print(ERROR_LEVEL, marker, format, (Object)arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.print(ERROR_LEVEL, marker, msg, t);
    }
}

