/*
 * Decompiled with CFR 0.152.
 */
package com.blongho.country_data;

import android.content.Context;
import androidx.annotation.Nullable;
import com.blongho.country_data.AssetsReader;
import com.blongho.country_data.Country;
import com.blongho.country_data.Currency;
import com.blongho.country_data.R;
import com.blongho.country_data.World;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class WorldData {
    public static final String CURRENT_VERSION = "1.5.1";
    private static final Map<String, Currency> currencyMap = new HashMap<String, Currency>();
    private static final Map<Country, Integer> countryFlagMap = new HashMap<Country, Integer>();
    private static WorldData instance;
    private static Country universe;

    private WorldData(Context ctx) {
        this.loadAllData(ctx);
    }

    private void loadAllData(Context context) {
        Country[] countries = this.loadCountries(context);
        this.loadCurrencies(context);
        for (Country country : countries) {
            int countryFlag;
            if (country.getAlpha2().equalsIgnoreCase("do")) {
                countryFlag = R.drawable.dominican;
            } else {
                String resource = "drawable/" + country.getAlpha2().toLowerCase();
                countryFlag = context.getResources().getIdentifier(resource, null, context.getPackageName());
            }
            country.setFlagResource(countryFlag);
            country.setCurrency(currencyMap.get(country.getAlpha2().toLowerCase()));
            if (this.isValid(country)) {
                countryFlagMap.put(country, countryFlag);
            }
            if (!country.getAlpha2().equalsIgnoreCase("xx")) continue;
            universe = country;
            universe.setFlagResource(WorldData.globe());
            countryFlagMap.put(universe, WorldData.globe());
        }
    }

    private Country[] loadCountries(Context context) {
        String values = AssetsReader.readFromAssets(context, R.raw.com_blongho_country_data_countries);
        Gson gson = new Gson();
        return (Country[])gson.fromJson(values, Country[].class);
    }

    private void loadCurrencies(Context context) {
        Currency[] currencies;
        String currencyArray = AssetsReader.readFromAssets(context, R.raw.com_blongho_country_data_currencies);
        Gson gson = new Gson();
        for (Currency currency : currencies = (Currency[])gson.fromJson(currencyArray, Currency[].class)) {
            if (!this.isValid(currency)) continue;
            currencyMap.put(currency.getCountry().toLowerCase(), currency);
        }
    }

    private boolean isValid(Country country) {
        return country != null && country.getCurrency() != null && country.getContinent() != null && country.getName() != null;
    }

    static int globe() {
        return R.drawable.globe;
    }

    private boolean isValid(Currency currency) {
        return currency != null && currency.getSymbol() != null && currency.getName() != null && currency.getCode() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WorldData getInstance(Context ctx) {
        if (instance != null) {
            return instance;
        }
        Class<WorldData> clazz = WorldData.class;
        synchronized (WorldData.class) {
            if (instance == null) {
                instance = new WorldData(ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    static List<Currency> currencies() {
        ArrayList<Currency> currencyList = new ArrayList<Currency>(currencyMap.values());
        Collections.sort(currencyList, new Comparator<Currency>(){

            @Override
            public int compare(Currency o1, Currency o2) {
                return o1.getCountry().compareTo(o2.getCountry());
            }
        });
        return currencyList;
    }

    static int flagFromCountry(String countryIdentifier) {
        if (countryIdentifier.equalsIgnoreCase("xx") || countryIdentifier.equalsIgnoreCase("XXX") || countryIdentifier.equalsIgnoreCase("world") || countryIdentifier.equalsIgnoreCase("globe")) {
            return WorldData.globe();
        }
        for (Country country : countryFlagMap.keySet()) {
            if (!country.hasProperty(countryIdentifier)) continue;
            return country.getFlagResource();
        }
        return WorldData.globe();
    }

    static Country countryFrom(String countryIdentifier) {
        for (Country country : countryFlagMap.keySet()) {
            if (!country.hasProperty(countryIdentifier)) continue;
            return country;
        }
        return universe;
    }

    static List<Country> countriesFrom(@Nullable World.Continent continent) {
        List<Country> allCountries = WorldData.countries();
        if (continent == null) {
            return allCountries;
        }
        ArrayList<Country> filtered = new ArrayList<Country>();
        for (Country country : allCountries) {
            if (!country.getContinent().equalsIgnoreCase(continent.getName())) continue;
            filtered.add(country);
        }
        return filtered;
    }

    static List<Country> countries() {
        ArrayList<Country> countryList = new ArrayList<Country>(countryFlagMap.keySet());
        Collections.sort(countryList, new Comparator<Country>(){

            @Override
            public int compare(Country o1, Country o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return countryList;
    }
}

