/*
 * Decompiled with CFR 0.152.
 */
package com.blongho.country_data;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.blongho.country_data.Country;
import com.blongho.country_data.Currency;
import com.blongho.country_data.WorldData;
import com.blongho.country_data.exception.CountryDataException;
import java.util.List;

public final class World {
    private static WorldData instance = null;

    private World() {
    }

    public static void init(Context context) {
        instance = WorldData.getInstance(context);
    }

    public static int getFlagOf(int countryCode) {
        if (instance == null) {
            throw new CountryDataException("You have to call World.init(getApplicationContext()) before this method.");
        }
        return World.getFlagOf(String.valueOf(countryCode));
    }

    public static int getFlagOf(String countryIdentifier) {
        if (instance == null) {
            throw new CountryDataException("You have to call World.init(getApplicationContext()) before this method.");
        }
        if (countryIdentifier.isEmpty()) {
            return World.getWorldFlag();
        }
        return WorldData.flagFromCountry(countryIdentifier);
    }

    public static int getWorldFlag() {
        if (instance == null) {
            throw new CountryDataException("You have to call World.init(getApplicationContext()) before this method.");
        }
        return WorldData.globe();
    }

    public static Country getCountryFrom(int numericCode) {
        if (instance == null) {
            throw new CountryDataException("You have to call World.init(getApplicationContext()) before this method.");
        }
        return World.getCountryFrom(String.valueOf(numericCode));
    }

    public static Country getCountryFrom(String countryIdentifier) {
        if (instance == null) {
            throw new CountryDataException("You have to call World.init(getApplicationContext()) before this method.");
        }
        return WorldData.countryFrom(countryIdentifier);
    }

    public static List<Country> getAllCountries() {
        if (instance == null) {
            throw new CountryDataException("You have to call World.init(getApplicationContext()) before this method.");
        }
        return WorldData.countries();
    }

    public static List<Currency> getAllCurrencies() {
        if (instance == null) {
            throw new CountryDataException("You have to call World.init(getApplicationContext()) before this method.");
        }
        return WorldData.currencies();
    }

    public static List<Country> getCountriesFrom(@Nullable Continent continent) {
        return WorldData.countriesFrom(continent);
    }

    public static String version() {
        if (instance == null) {
            throw new CountryDataException("You have to call World.init(getApplicationContext()) before this method.");
        }
        return "1.5.1";
    }

    public static enum Continent {
        AFRICA("Africa"),
        EUROPE("Europe"),
        ASIA("Asia"),
        OCEANIA("Oceania"),
        SOUTH_AMERICA("South America"),
        NORTH_AMERICA("North America"),
        ANTARTICA("Antarctica");

        private final String name;

        private Continent(String continent) {
            this.name = continent;
        }

        public String getName() {
            return this.name;
        }

        @NonNull
        public String toString() {
            return this.name;
        }
    }
}

