/*
 * Decompiled with CFR 0.152.
 */
package com.blongho.country_data;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.blongho.country_data.Currency;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Country
implements Parcelable {
    public static final Parcelable.Creator<Country> CREATOR = new Parcelable.Creator<Country>(){

        public Country createFromParcel(Parcel in) {
            return new Country(in);
        }

        public Country[] newArray(int size) {
            return new Country[size];
        }
    };
    private static final Map<String, String> CONTINENTS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("AF", "Africa");
            this.put("AS", "Asia");
            this.put("NA", "North America");
            this.put("SA", "South America");
            this.put("OC", "Oceania");
            this.put("EU", "Europe");
            this.put("AN", "Antarctica");
            this.put("UNX", "Universe");
        }
    });
    private final String id;
    private final String name;
    private final String alpha2;
    private final String alpha3;
    private final String capital;
    private final String continent;
    private final String area;
    private final String population;
    @DrawableRes
    private int flagResource;
    private Currency currency;

    Country(String id, String name, String alpha2, String alpha3, String capital, String continent, String area, String population, @DrawableRes int flagResource, Currency currency) {
        this.id = id;
        this.name = name;
        this.alpha2 = alpha2;
        this.alpha3 = alpha3;
        this.capital = capital;
        this.continent = continent;
        this.area = area;
        this.population = population;
        this.flagResource = flagResource;
        this.currency = currency;
    }

    protected Country(Parcel in) {
        this.id = in.readString();
        this.name = in.readString();
        this.alpha2 = in.readString();
        this.alpha3 = in.readString();
        this.capital = in.readString();
        this.continent = in.readString();
        this.area = in.readString();
        this.population = in.readString();
        this.flagResource = in.readInt();
        this.currency = (Currency)in.readParcelable(Currency.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.id);
        parcel.writeString(this.name);
        parcel.writeString(this.alpha2);
        parcel.writeString(this.alpha3);
        parcel.writeString(this.capital);
        parcel.writeString(this.continent);
        parcel.writeString(this.area);
        parcel.writeString(this.population);
        parcel.writeInt(this.flagResource);
        parcel.writeParcelable((Parcelable)this.currency, flags);
    }

    public final String getCapital() {
        return this.capital;
    }

    public final String getName() {
        return this.name;
    }

    public final String getAlpha2() {
        return this.alpha2;
    }

    public final String getAlpha3() {
        return this.alpha3;
    }

    public final int getFlagResource() {
        return this.flagResource;
    }

    void setFlagResource(@DrawableRes int flagResource) {
        this.flagResource = flagResource;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.alpha2 != null ? this.alpha2.hashCode() : 0);
        result = 31 * result + (this.alpha3 != null ? this.alpha3.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Country country = (Country)o;
        if (this.id != null ? !this.id.equals(country.id) : country.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(country.name) : country.name != null) {
            return false;
        }
        if (this.alpha2 != null ? !this.alpha2.equals(country.alpha2) : country.alpha2 != null) {
            return false;
        }
        return this.alpha3 != null ? this.alpha3.equals(country.alpha3) : country.alpha3 == null;
    }

    @NonNull
    public String toString() {
        return "Country{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", alpha2='" + this.alpha2 + '\'' + ", alpha3='" + this.alpha3 + '\'' + ", capital='" + this.capital + '\'' + ", continent='" + this.getContinent() + '\'' + ", area='" + this.getArea() + '\'' + ", population='" + this.getPopulation() + '\'' + ", currency=" + this.currency + '}';
    }

    public final String getContinent() {
        return CONTINENTS.get(this.continent);
    }

    public final double getArea() {
        String tmp = this.formatStringToNumber(this.area);
        return Double.parseDouble(tmp.replace(".0", ""));
    }

    public final long getPopulation() {
        return Long.parseLong(this.formatStringToNumber(this.population));
    }

    private String formatStringToNumber(String unformatted) {
        return unformatted.replaceAll(",", "");
    }

    public final Currency getCurrency() {
        return this.currency;
    }

    void setCurrency(Currency currency) {
        this.currency = currency;
    }

    boolean hasProperty(String attribute) {
        return attribute.equalsIgnoreCase(this.alpha2) || attribute.equalsIgnoreCase(this.alpha3) || attribute.equalsIgnoreCase(this.name) || attribute.equalsIgnoreCase(String.valueOf(this.getId()));
    }

    public final int getId() {
        return Integer.parseInt(this.id);
    }
}

