/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250ext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.infordata.em.tn5250ext.XI5250EmulatorExt;
import net.infordata.em.tn5250ext.XI5250PanelHandler;
import net.infordata.em.tn5250ext.XI5250PanelsDispatcher;

public class XI5250SimplePanelsDispatcher
extends XI5250PanelsDispatcher {
    private static final Logger LOGGER = Logger.getLogger(XI5250SimplePanelsDispatcher.class.getName());
    private static transient String DELIMITERS = "";
    private transient HashMap<String, ArrayList<XI5250PanelHandler>> ivPanels;

    public XI5250SimplePanelsDispatcher() {
    }

    public XI5250SimplePanelsDispatcher(XI5250EmulatorExt aEmulator) {
        super(aEmulator);
    }

    private static String calcKey(String str, int excludeTokens) {
        String res = "";
        StringTokenizer st = new StringTokenizer(str, DELIMITERS);
        int n = Math.max(0, st.countTokens() - excludeTokens);
        for (int i = n - 1; i >= 0; --i) {
            res = res + " " + st.nextToken();
        }
        return res;
    }

    @Override
    public synchronized void addPanelHandler(XI5250PanelHandler aPanel) {
        ArrayList vt;
        if (this.ivPanels == null) {
            this.ivPanels = new HashMap();
        }
        String key = XI5250SimplePanelsDispatcher.calcKey(aPanel.getTitle(), 0);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("addPanelHandler: [" + key + "] " + aPanel);
        }
        if (!(vt = this.ivPanels.computeIfAbsent(key, k -> new ArrayList(10))).contains(aPanel)) {
            vt.add(aPanel);
        }
    }

    @Override
    public synchronized void removePanelHandler(XI5250PanelHandler aPanel) {
        ArrayList<XI5250PanelHandler> vt;
        if (this.ivPanels == null) {
            return;
        }
        String key = XI5250SimplePanelsDispatcher.calcKey(aPanel.getTitle(), 0);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("removePanelHandler: [" + key + "] " + aPanel);
        }
        if ((vt = this.ivPanels.get(key)) == null) {
            return;
        }
        vt.remove(aPanel);
        if (vt.size() <= 0) {
            this.ivPanels.remove(key);
        }
    }

    @Override
    protected synchronized XI5250PanelHandler getCurrentPanelHandler() {
        String key;
        ArrayList<XI5250PanelHandler> vt;
        XI5250EmulatorExt em = this.getEmulator();
        String title = em.getString().substring(0, em.getCrtSize().width);
        int j = 0;
        do {
            key = XI5250SimplePanelsDispatcher.calcKey(title, j++);
            vt = this.ivPanels.get(key);
            if (!LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.finer("try [" + key + "] " + (vt != null ? "found" : "next"));
        } while (vt == null && key != null && key.length() > 0);
        if (vt == null) {
            return null;
        }
        for (int i = vt.size() - 1; i >= 0; --i) {
            XI5250PanelHandler panelHndl = vt.get(i);
            if (!panelHndl.detailedTest()) continue;
            vt.remove(panelHndl);
            vt.add(panelHndl);
            return panelHndl;
        }
        return null;
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            DELIMITERS = DELIMITERS + (char)i;
        }
    }
}

