/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250ext;

import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.tn5250.XI5250Frame;
import net.infordata.em.tn5250ext.XI5250EmulatorExt;
import net.infordata.em.tn5250ext.XI5250FieldConnection;
import net.infordata.em.tn5250ext.XI5250PanelConnection;
import net.infordata.em.tn5250ext.XI5250PanelHandler;
import net.infordata.em.tn5250ext.XI5250PanelsDispatcher;
import net.infordata.em.tn5250ext.XI5250SimplePanelsDispatcher;
import net.infordata.em.tn5250ext.XIHint;

public class Test {
    private Test() {
    }

    public static void main(String[] argv) {
        XI5250EmulatorExt em = new XI5250EmulatorExt();
        em.setTerminalType("IBM-3477-FC");
        em.setKeyboardQueue(true);
        em.setHintOnActiveField(true);
        XI5250SimplePanelsDispatcher disp = new XI5250SimplePanelsDispatcher(em);
        new TestHandler(disp);
        if (argv.length >= 1) {
            em.setHost(argv[0]);
            em.setActive(true);
        }
        XI5250Frame frm = new XI5250Frame("tn5250ext 1.19m", em);
        if (argv.length >= 2 && "3DFX".equals(argv[1].toUpperCase())) {
            em.setDefFieldsBorderStyle(3);
            em.setDefBackground(SystemColor.control);
        }
        frm.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        frm.setBounds(0, 0, 570, 510);
        frm.centerOnScreen();
        frm.setVisible(true);
    }

    private static class FontsCache {
        private Font[] ivFonts = new Font[50];
        private Font ivFont;

        public FontsCache(Font font) {
            this.ivFont = font;
        }

        public Font getFont(int size) {
            if (this.ivFonts[size - 1] == null) {
                this.ivFonts[size - 1] = new Font(this.ivFont.getName(), this.ivFont.getStyle(), size);
            }
            return this.ivFonts[size - 1];
        }
    }

    private static class TestHandler
    extends XI5250PanelHandler {
        private FontsCache ivFontsCache;
        private List<JButton> ivButtons = new ArrayList<JButton>();

        public TestHandler(XI5250PanelsDispatcher disp) {
            super(disp, "");
        }

        @Override
        protected void sizeChanged() {
            super.sizeChanged();
            XI5250EmulatorExt em = this.getEmulator();
            for (JButton btn : this.ivButtons) {
                btn.setFont(this.ivFontsCache.getFont(Math.max(1, em.getFont().getSize() - 2)));
            }
        }

        @Override
        protected boolean detailedTest() {
            return true;
        }

        @Override
        protected void start() {
            this.ivButtons.clear();
            final XI5250EmulatorExt em = this.getEmulator();
            int crtWidth = em.getCrtSize().width;
            for (final XI5250Field field : this.getFields()) {
                boolean isButton = false;
                if (field.isIOOnly()) {
                    int col = field.getCol() - 1;
                    int row = field.getRow();
                    if (col >= 0 && "<".equals(em.getString(col, row, 1))) {
                        int len;
                        int fieldEnd = col + field.getLength();
                        String str = em.getString(fieldEnd + 1, row, crtWidth - fieldEnd);
                        int idx = str.indexOf(">");
                        int n = len = idx < 0 ? -1 : idx + 2 + 1;
                        if (len > 0) {
                            isButton = true;
                            String txt = em.getString(col + 1, row, len - 2);
                            JButton btn = new JButton(txt);
                            if (this.ivFontsCache == null) {
                                this.ivFontsCache = new FontsCache(btn.getFont());
                            }
                            btn.setFont(this.ivFontsCache.getFont(Math.max(1, em.getFont().getSize() - 2)));
                            btn.setMargin(new Insets(2, 2, 2, 2));
                            btn.setFocusable(false);
                            btn.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    em.setCursorPos(field.getCol(), field.getRow());
                                    em.requestFocusInWindow();
                                    em.processRawKeyEvent(new KeyEvent(em, 401, 0L, 0, 10, '\n'));
                                }
                            });
                            this.ivButtons.add(btn);
                            new XI5250PanelConnection(this, btn, col, row, len, 1);
                        }
                    }
                }
                if (!isButton) {
                    this.setFieldHint(field, new XIHint(field.toString()));
                    JPopupMenu pm = new JPopupMenu();
                    pm.add(new JMenuItem(field.toString()));
                    this.setFieldPopupMenu(field, pm);
                    JButton btn = new JButton();
                    new XI5250FieldConnection(this, field, btn);
                }
                new XI5250PanelConnection(this, new JButton("+-"), 15, 15, 10, 6);
            }
        }

        @Override
        protected void stop() {
            this.ivButtons.clear();
        }
    }
}

