/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import net.infordata.em.tn5250.XI5250Exception;
import net.infordata.em.tn5250.XI5250Ord;
import net.infordata.em.tnprot.XITelnet;

public class XISOHOrd
extends XI5250Ord {
    protected byte[] ivData;
    protected int ivLen;

    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException, XI5250Exception {
        int i = 0;
        this.ivLen = inStream.read();
        if (this.ivLen > 0) {
            int bb;
            this.ivData = new byte[this.ivLen];
            for (i = 0; i < this.ivLen && (bb = inStream.read()) != -1; ++i) {
                this.ivData[i] = (byte)bb;
            }
        }
        if (this.ivLen < 0 || this.ivLen > 7 || i < this.ivLen) {
            throw new XI5250Exception("Bad SOH Order", 10050131);
        }
    }

    @Override
    protected void execute() {
        this.ivEmulator.ivCmdList.ivICOrderExecuted = false;
        this.ivEmulator.removeFields();
        this.ivEmulator.ivPendingCmd = null;
        if (this.ivLen >= 2 && this.ivLen >= 3 && this.ivLen >= 4) {
            this.ivEmulator.setErrorRow(this.ivData[3] - 1);
            if (this.ivLen >= 7) {
                int xx = XITelnet.toInt(this.ivData[4]) << 16 | XITelnet.toInt(this.ivData[5]) << 8 | XITelnet.toInt(this.ivData[6]);
                this.ivEmulator.setFunctionKeysMask(xx);
            }
        }
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.ivLen; ++i) {
            str = str + XITelnet.toHex(this.ivData[i]) + ",";
        }
        return super.toString() + " [" + this.ivLen + ",[" + str + "]]";
    }
}

