/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import net.infordata.em.tn5250.XI5250Cmd;
import net.infordata.em.tn5250.XI5250Exception;

public class XIRollCmd
extends XI5250Cmd {
    boolean ivDown;
    int ivNRows;
    int ivTopRow;
    int ivBottomRow;

    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException, XI5250Exception {
        int i;
        int[] bb = new int[3];
        for (i = 0; i < 3 && (bb[i] = inStream.read()) >= 0; ++i) {
        }
        if (i < 3) {
            throw new XI5250Exception("Roll parameter missing", 10050122);
        }
        this.ivDown = (bb[0] & 0x80) != 0;
        this.ivNRows = bb[0] & 0x1F;
        this.ivTopRow = bb[1];
        this.ivBottomRow = bb[2];
        if (this.ivTopRow > this.ivBottomRow) {
            throw new XI5250Exception("TopRow greater then BottomRow", 10050122);
        }
    }

    @Override
    protected void execute() {
        this.ivEmulator.scroll(this.ivDown, this.ivTopRow - 1, this.ivBottomRow, this.ivNRows);
    }
}

