/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.OutputStream;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.crt5250.XI5250FieldSaver;
import net.infordata.em.crt5250.XIEbcdicTranslator;
import net.infordata.em.tn5250.XI5250Emulator;

public class XIFieldTo5250Stream
implements XI5250FieldSaver {
    XI5250Emulator ivEmulator;
    OutputStream ivOut;
    boolean ivOnlyMDT;

    public XIFieldTo5250Stream(XI5250Emulator aEmulator, OutputStream aOutStream, boolean onlyMDT) {
        this.ivEmulator = aEmulator;
        this.ivOut = aOutStream;
        this.ivOnlyMDT = onlyMDT;
    }

    @Override
    public void write(XI5250Field aField, String aStr) throws IOException {
        int j;
        int i;
        int j2;
        if (this.ivOnlyMDT && !aField.isMDTOn()) {
            return;
        }
        XIEbcdicTranslator translator = this.ivEmulator.getTranslator();
        if (aStr.length() > 0 && aField.isSignedNumeric()) {
            int i2;
            StringBuilder strBuf = new StringBuilder(aStr);
            for (i2 = strBuf.length() - 1; i2 >= 0 && !Character.isDigit(strBuf.charAt(i2)); --i2) {
            }
            for (j2 = i2 - 1; j2 >= 0; --j2) {
                if (Character.isDigit(strBuf.charAt(j2))) continue;
                strBuf.setCharAt(j2, '0');
            }
            if (strBuf.charAt(strBuf.length() - 1) == '-') {
                if (i2 >= 0) {
                    byte xx = translator.toEBCDIC(strBuf.charAt(i2));
                    xx = (byte)(xx & 0xF);
                    xx = (byte)(xx | 0xD0);
                    strBuf.setCharAt(i2, translator.toChar(xx));
                    aStr = new String(strBuf).substring(0, strBuf.length() - 1);
                } else {
                    aStr = "";
                }
            } else {
                aStr = new String(strBuf);
            }
        }
        if (this.ivOnlyMDT) {
            byte[] cBuf = new byte[]{17, (byte)(aField.getRow() + 1), (byte)(aField.getCol() + 1)};
            this.ivOut.write(cBuf);
            for (i = aStr.length() - 1; i >= 0 && aStr.charAt(i) == '\u0000'; --i) {
            }
        }
        byte[] strBuf = new byte[i + 1];
        int linearPos = this.ivEmulator.toLinearPos(aField.getCol(), aField.getRow());
        int len = Math.min(i + 1, aStr.length());
        byte space = translator.toEBCDIC(' ');
        for (j = 0; j < len; ++j) {
            char ch = aStr.charAt(j);
            if (ch == '\u0001') {
                ch = (char)this.ivEmulator.getAttr(this.ivEmulator.toColPos(linearPos + j), this.ivEmulator.toRowPos(linearPos + j));
                strBuf[j] = (byte)ch;
                continue;
            }
            strBuf[j] = ch == '\u0000' ? space : translator.toEBCDIC(ch);
        }
        for (j = len; j < i + 1; ++j) {
            strBuf[j] = space;
        }
        if (i >= 0) {
            for (j2 = 0; j2 < i + 1; ++j2) {
                if (strBuf[j2] != 0) continue;
                strBuf[j2] = 64;
            }
            this.ivOut.write(strBuf, 0, i + 1);
        }
    }
}

