/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.infordata.em.tn5250.XIImagesBdl;
import net.infordata.em.util.XIRatioLayout;

public class XI5250StatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int SHIFT_UP = 0;
    public static final int SHIFT_DOWN = 1;
    public static final int CAPS_LOCK_UP = 0;
    public static final int CAPS_LOCK_DOWN = 1;
    public static final int MESSAGE_OFF = 0;
    public static final int MESSAGE_ON = 1;
    static XIImagesBdl cvImagesBdl = XIImagesBdl.getImagesBdl();
    private static Image cvTemporaryLockImage = cvImagesBdl.getImage("TemporaryLock");
    private static Image cvNormalLockImage = cvImagesBdl.getImage("NormalLock");
    private static Image cvHelpImage = cvImagesBdl.getImage("Help");
    private static Image cvShiftDownImage = cvImagesBdl.getImage("ShiftDown");
    private static Image cvCapsLockImage = cvImagesBdl.getImage("CapsLock");
    private static Image cvMessageImage = cvImagesBdl.getImage("Message");
    private static Image cvFlashImage = cvImagesBdl.getImage("Flash");
    private TextAndImage ivFlashArea;
    private TextAndImage ivStateArea;
    private TextAndImage ivMessageArea;
    private TextAndImage ivShiftArea;
    private TextAndImage ivCapsLockArea;
    private JLabel ivCoordArea;
    private boolean ivFlashOn;
    private int ivShiftAreaState = -1;
    private int ivState = -2;

    public XI5250StatusBar() {
        super(new XIRatioLayout(4));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.addComponents();
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    public void addComponents() {
        Border border = BorderFactory.createEtchedBorder();
        this.ivFlashArea = new TextAndImage(1);
        this.ivFlashArea.setBorder(border);
        this.add((Component)this.ivFlashArea, new XIRatioLayout.Constraints(0.03f));
        TextAndImage dummyArea = new TextAndImage(1);
        dummyArea.setBorder(border);
        this.add((Component)dummyArea, new XIRatioLayout.Constraints(0.03f));
        this.ivStateArea = new TextAndImage();
        this.ivStateArea.setBorder(border);
        this.add((Component)this.ivStateArea, new XIRatioLayout.Constraints(0.3f));
        this.ivMessageArea = new TextAndImage(1);
        this.ivMessageArea.setBorder(border);
        this.add((Component)this.ivMessageArea, new XIRatioLayout.Constraints(0.03f));
        this.ivShiftArea = new TextAndImage(1);
        this.ivShiftArea.setBorder(border);
        this.add((Component)this.ivShiftArea, new XIRatioLayout.Constraints(0.03f));
        this.ivCapsLockArea = new TextAndImage(1);
        this.ivCapsLockArea.setBorder(border);
        this.add((Component)this.ivCapsLockArea, new XIRatioLayout.Constraints(0.03f));
        this.ivCoordArea = new JLabel(null, null, 4);
        this.ivCoordArea.setFont(null);
        this.ivCoordArea.setBorder(border);
        this.add((Component)this.ivCoordArea, new XIRatioLayout.Constraints(0.15f, 2));
    }

    public void setCoordArea(int aCol, int aRow) {
        this.ivCoordArea.setText(aRow + " / " + aCol + " ");
    }

    public void setFlashArea(boolean flag) {
        if (flag == this.ivFlashOn) {
            return;
        }
        this.ivFlashOn = flag;
        if (flag) {
            this.ivFlashArea.setImage(cvFlashImage);
        } else {
            this.ivFlashArea.setImage(null);
        }
    }

    public void setShiftArea(int aState) {
        if (aState == this.ivShiftAreaState) {
            return;
        }
        this.ivShiftAreaState = aState;
        if (aState == 1) {
            this.ivShiftArea.setImage(cvShiftDownImage);
        } else {
            this.ivShiftArea.setImage(null);
        }
    }

    public void setCapsLockArea(int aState) {
        if (aState == 1) {
            this.ivCapsLockArea.setImage(cvCapsLockImage);
        } else {
            this.ivCapsLockArea.setImage(null);
        }
    }

    public void setMessageArea(int aState) {
        if (aState == 1) {
            this.ivMessageArea.setImage(cvMessageImage);
        } else {
            this.ivMessageArea.setImage(null);
        }
    }

    public void setStateArea(int aState) {
        if (aState == this.ivState) {
            return;
        }
        switch (aState) {
            case 0: {
                this.ivStateArea.setImage(null);
                this.ivStateArea.setText("HARDWARE_ERROR");
                break;
            }
            case 1: {
                this.ivStateArea.setImage(cvNormalLockImage);
                this.ivStateArea.setText("SYSTEM");
                break;
            }
            case 2: {
                this.ivStateArea.setImage(null);
                this.ivStateArea.setText("");
                break;
            }
            case 3: {
                this.ivStateArea.setImage(null);
                this.ivStateArea.setText("POST_HELP");
                break;
            }
            case 4: {
                this.ivStateArea.setImage(null);
                this.ivStateArea.setText("");
                break;
            }
            case 5: {
                this.ivStateArea.setImage(cvHelpImage);
                this.ivStateArea.setText("");
                break;
            }
            case 6: {
                this.ivStateArea.setImage(null);
                this.ivStateArea.setText("SS_MESSAGE");
                break;
            }
            case 7: {
                this.ivStateArea.setImage(null);
                this.ivStateArea.setText("SYSTEM_REQUEST");
                break;
            }
            case -1: {
                this.ivStateArea.setImage(cvTemporaryLockImage);
                this.ivStateArea.setText("");
            }
        }
    }

    protected static class TextAndImage
    extends JComponent {
        private static final long serialVersionUID = 1L;
        public static final int LEFT = 0;
        public static final int CENTER = 1;
        private Image ivImage = null;
        private String ivText = null;
        private int ivAlignment;
        private final int ivHGap = 2;

        public TextAndImage(int alignment) {
            this.ivAlignment = alignment;
        }

        public TextAndImage() {
            this(0);
        }

        public void setText(String aText) {
            this.ivText = aText;
            this.repaint();
        }

        public void setImage(Image aImage) {
            this.ivImage = aImage;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics gr) {
            Insets insets = this.getInsets();
            int imageWidth = 0;
            int imageHeight = 0;
            int textWidth = 0;
            Dimension dim = this.getSize();
            FontMetrics fm = null;
            if (this.ivImage != null) {
                int w = this.ivImage.getWidth(this);
                int h = this.ivImage.getHeight(this);
                imageHeight = dim.height - insets.top - insets.bottom;
                imageWidth = w * imageHeight / h;
            }
            if (this.ivText != null && this.ivText.length() != 0) {
                fm = gr.getFontMetrics();
                textWidth = fm.stringWidth(this.ivText);
            }
            int width = imageWidth + textWidth + (this.ivImage != null && fm != null ? 2 : 0);
            int x = insets.left;
            if (this.ivAlignment == 1) {
                x = (dim.width - width) / 2;
            }
            if (this.ivImage != null) {
                gr.drawImage(this.ivImage, x, insets.top, imageWidth, imageHeight, this);
                x += imageWidth + 2;
            }
            if (fm != null) {
                gr.setColor(this.getForeground());
                int y = (dim.height + fm.getHeight()) / 2;
                gr.drawString(this.ivText, x, y - fm.getDescent());
            }
        }
    }
}

